/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.ojvmwcu;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUAutoLoad;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUClasses;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUException;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUInputParameters;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUWrappers;

public class OjvmWCU {
    private static String helpOptionsFilepath = "helpOptions.txt";

    public static void main(String[] args) throws OjvmWCUException {
        OjvmWCUInputParameters inp = new OjvmWCUInputParameters();
        OjvmWCU ojvmWCU = new OjvmWCU();
        Boolean doneFirstPart = Boolean.FALSE;
        try {
            String[] input = args;
            if (input == null || input.length == 0) {
                ojvmWCU.displayUsage(inp);
            }
            inp.setInputArguments(input);
            inp.OWCULogger.info("Starting OjvmWCU");
            OjvmWCUClasses cl = new OjvmWCUClasses(inp);
            cl.generateClasses();
            OjvmWCUWrappers wr = new OjvmWCUWrappers(inp);
            if (inp.isWSDL.booleanValue()) {
                wr.generateWrappersJAXWS();
            }
            if (inp.isWADL.booleanValue()) {
                wr.generateWrappersJAXRS();
            }
            wr.generateCleanupWrapper();
            wr.createHelpFile();
            doneFirstPart = Boolean.TRUE;
        }
        catch (OjvmWCUException oe) {
            inp.OWCULogger.severe(oe.getMessage());
            if (oe.errorCode == 1) {
                ojvmWCU.displayUsage(inp);
            }
        }
        catch (Exception e) {
            throw new OjvmWCUException(2, "Exception", inp, e);
        }
        finally {
            inp.cleanupTmpDir();
        }
        try {
            if (doneFirstPart.booleanValue() && inp.fullAuto.booleanValue()) {
                inp.OWCULogger.info("Starting AutoLoading");
                OjvmWCUAutoLoad doAuto = new OjvmWCUAutoLoad(inp);
                doAuto.doAutomatedProcedure();
            }
        }
        catch (OjvmWCUException ex) {
            inp.OWCULogger.severe("Loading to DB failed : " + ex.getMessage());
        }
        inp.OWCULogger.info("Done Executing OjvmWCU");
    }

    public void displayUsage(OjvmWCUInputParameters inp) {
        String usageStr = "";
        try {
            String curline;
            InputStream in = this.getClass().getResourceAsStream(helpOptionsFilepath);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((curline = br.readLine()) != null) {
                usageStr = usageStr + curline + "\n";
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        inp.OWCULogger.info(usageStr);
        System.exit(0);
    }
}

