/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.ojvmwcu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.aurora.server.tools.loadjava.LoadJavaMain;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUException;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUInputParameters;

public class OjvmWCUAutoLoad {
    private String loadJavaStartStr = "";
    OjvmWCUInputParameters inpPar = null;
    private String password = "";

    public OjvmWCUAutoLoad(OjvmWCUInputParameters inp) {
        this.inpPar = inp;
        this.loadJavaStartStr = "-t -r -u ";
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.loadJavaStartStr = "-v " + this.loadJavaStartStr;
        }
    }

    public void doAutomatedProcedure() throws OjvmWCUException {
        this.questionnaire();
        this.loadClientJar(this.inpPar.user, this.password);
        this.createWrappers(this.inpPar.user, this.password);
    }

    private void questionnaire() throws OjvmWCUException {
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader inputFromUser = new BufferedReader(isr);
        if (this.inpPar.user.equals("")) {
            System.out.println("Enter WebServiceUserName : ");
            this.inpPar.user = this.getStringValue(inputFromUser, Boolean.TRUE, "");
        }
        System.out.println("Enter Password for " + this.inpPar.user + ": ");
        this.password = this.promptForPassword(inputFromUser);
        this.getDBRelatedOptions(inputFromUser);
        try {
            inputFromUser.close();
            isr.close();
        }
        catch (Exception ex) {
            throw new OjvmWCUException(2, "Cannot Close Reader", this.inpPar, ex);
        }
    }

    public void getDBRelatedOptions(BufferedReader inputFromUser) throws OjvmWCUException {
        if (this.inpPar.oraServ.equals("") && this.inpPar.oraSID.equals("")) {
            System.out.println("  1. Service \n  2. SID \n Enter Option [2] :");
            int opt = this.getIntValue(inputFromUser, Boolean.TRUE, 2);
            if (opt == 1) {
                System.out.println("Enter Oracle Service : ");
                this.inpPar.oraServ = this.getStringValue(inputFromUser, Boolean.TRUE, "");
            } else {
                System.out.println("Enter Oracle SID : ");
                this.inpPar.oraSID = this.getStringValue(inputFromUser, Boolean.TRUE, "");
            }
        }
    }

    public Boolean executeSqlStatementUpdate(String userName, String password, String plsqlCode) throws OjvmWCUException {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException ex) {
            OjvmWCUException e = new OjvmWCUException(12, this.inpPar, ex);
            throw e;
        }
        Connection con = null;
        String conStr = "jdbc:oracle:thin:@";
        conStr = !this.inpPar.oraSID.equalsIgnoreCase("") ? conStr + this.inpPar.dbhost + ":" + this.inpPar.dbport + ":" + this.inpPar.oraSID : conStr + "//" + this.inpPar.dbhost + ":" + this.inpPar.dbport + "/" + this.inpPar.oraServ;
        try {
            con = DriverManager.getConnection(conStr, userName, password);
        }
        catch (SQLException ex) {
            OjvmWCUException e = new OjvmWCUException(13, this.inpPar, ex);
            throw e;
        }
        try {
            Statement plsqlExecute = con.createStatement();
            plsqlExecute.execute(plsqlCode);
            plsqlExecute.close();
            con.close();
        }
        catch (SQLException ex) {
            String mess = "";
            if (ex.getErrorCode() == 2303) {
                mess = "Cannot drop or replace a type with type or table dependents\n1. If you are running OjvmWCU for the second time\n\tPlease clean up the Database using the <web-service name>_cleanup_wrapper.sql and try again\n2. Your Database already have some of the types which are being defined by OjvmWCU\n\tPlease change the web-service name so that OjvmWCU modifies the names accordingly";
            }
            OjvmWCUException e = new OjvmWCUException(13, mess, this.inpPar, ex);
            throw e;
        }
        return Boolean.TRUE;
    }

    private Boolean loadJavaClasses(String dbConnectionString) throws OjvmWCUException {
        String loadjavaCommand = dbConnectionString + " " + this.inpPar.jarFileName;
        try {
            LoadJavaMain.serverMain((String)loadjavaCommand);
        }
        catch (Exception ex) {
            throw new OjvmWCUException(14, this.inpPar, ex);
        }
        return Boolean.TRUE;
    }

    private Boolean loadClientJar(String webserviceUser, String webserviceUserPassword) throws OjvmWCUException {
        String loadJavaDbConnectionString = this.loadJavaStartStr + webserviceUser + "/" + webserviceUserPassword + "@" + this.inpPar.dbhost + ":" + this.inpPar.dbport;
        String verbosePrint = "";
        if (!this.inpPar.oraSID.equalsIgnoreCase("")) {
            loadJavaDbConnectionString = loadJavaDbConnectionString + ":" + this.inpPar.oraSID;
            verbosePrint = this.inpPar.oraSID;
        } else {
            loadJavaDbConnectionString = loadJavaDbConnectionString + "/" + this.inpPar.oraServ;
            verbosePrint = this.inpPar.oraServ;
        }
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Loading Classes to " + verbosePrint + " @" + this.inpPar.dbhost + ":" + this.inpPar.dbport);
        }
        this.loadJavaClasses(loadJavaDbConnectionString);
        return Boolean.TRUE;
    }

    private Boolean createWrappers(String webserviceUser, String webserviceUserPassword) throws OjvmWCUException {
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Creating Wrappers for Web Service " + this.inpPar.nameOfWebService);
        }
        String plsqlCodeWrapper = "";
        for (int j = 0; j < this.inpPar.webServiceWrapperContents.size(); ++j) {
            if (!this.inpPar.webServiceWrapperContents.get(j).startsWith("/")) {
                plsqlCodeWrapper = plsqlCodeWrapper + this.inpPar.webServiceWrapperContents.get(j) + "\n";
                continue;
            }
            this.executeSqlStatementUpdate(webserviceUser, webserviceUserPassword, plsqlCodeWrapper);
            plsqlCodeWrapper = "";
        }
        this.inpPar.OWCULogger.info(plsqlCodeWrapper);
        return Boolean.TRUE;
    }

    private int getIntValue(BufferedReader in, Boolean noDefaultVal, int defaultVal) throws OjvmWCUException {
        String inpFromUser;
        if (noDefaultVal.booleanValue()) {
            while (true) {
                String inpFromUser2 = "";
                try {
                    inpFromUser2 = in.readLine();
                }
                catch (IOException ex) {
                    OjvmWCUException e = new OjvmWCUException(this.inpPar, ex);
                    throw e;
                }
                if (!inpFromUser2.equalsIgnoreCase("")) {
                    return Integer.parseInt(inpFromUser2);
                }
                System.out.println("There is no default Value for this Option");
                System.out.println("Please enter any option");
            }
        }
        try {
            inpFromUser = in.readLine();
        }
        catch (IOException ex) {
            OjvmWCUException e = new OjvmWCUException(this.inpPar, ex);
            throw e;
        }
        if (!inpFromUser.equalsIgnoreCase("")) {
            return Integer.parseInt(inpFromUser);
        }
        return defaultVal;
    }

    private String getStringValue(BufferedReader in, Boolean noDefaultVal, String defaultVal) throws OjvmWCUException {
        String inpFromUser;
        if (noDefaultVal.booleanValue()) {
            while (true) {
                String inpFromUser2;
                try {
                    inpFromUser2 = in.readLine();
                }
                catch (IOException ex) {
                    OjvmWCUException e = new OjvmWCUException(this.inpPar, ex);
                    throw e;
                }
                if (!inpFromUser2.equalsIgnoreCase("")) {
                    return inpFromUser2;
                }
                System.out.println("There is no default Value for this Option");
                System.out.println("Please enter any option");
            }
        }
        try {
            inpFromUser = in.readLine();
        }
        catch (IOException ex) {
            OjvmWCUException e = new OjvmWCUException(this.inpPar, ex);
            throw e;
        }
        if (!inpFromUser.equalsIgnoreCase("")) {
            return inpFromUser;
        }
        return defaultVal;
    }

    private String promptForPassword(BufferedReader in) {
        String password = "";
        HidePasswordFromCommandLine hideThread = new HidePasswordFromCommandLine();
        hideThread.start();
        System.out.println("\nPassword:");
        System.out.print(" ");
        hideThread.hideInput = true;
        try {
            password = in.readLine();
            hideThread.stopThread = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.print("\b \b");
        return password;
    }

    class HidePasswordFromCommandLine
    extends Thread {
        boolean stopThread = false;
        boolean hideInput = false;
        boolean shortMomentGone = false;

        HidePasswordFromCommandLine() {
        }

        @Override
        public void run() {
            try {
                HidePasswordFromCommandLine.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.shortMomentGone = true;
            while (!this.stopThread) {
                if (this.hideInput) {
                    System.out.print("\b*");
                }
                try {
                    HidePasswordFromCommandLine.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

