/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.ojvmwcu;

import java.util.HashMap;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUInputParameters;

public class OjvmWCUException
extends Exception {
    public int errorCode = 0;
    public String additionalMessage = "";
    public static HashMap<Integer, String> OjvmWCUExceptionTable = new HashMap();

    static void generateTable() {
        OjvmWCUExceptionTable.put(0, "OJVM WCU Exception");
        OjvmWCUExceptionTable.put(1, "Invalid Option");
        OjvmWCUExceptionTable.put(2, "Generic Error ");
        OjvmWCUExceptionTable.put(3, "Directory / File doesn't exist");
        OjvmWCUExceptionTable.put(4, "Cannot Generate Client Stub classes ");
        OjvmWCUExceptionTable.put(5, "Create Jar Generic Error ");
        OjvmWCUExceptionTable.put(6, "Exception compiling file ");
        OjvmWCUExceptionTable.put(7, "Class cannot be loaded ");
        OjvmWCUExceptionTable.put(8, "Generate Class file not found ");
        OjvmWCUExceptionTable.put(9, "Exception during Jar Creation ");
        OjvmWCUExceptionTable.put(10, "Exception running Jax-WS utility wsimport ");
        OjvmWCUExceptionTable.put(11, "Problem with the input from User");
        OjvmWCUExceptionTable.put(12, "JDBC Driver not found");
        OjvmWCUExceptionTable.put(13, "Problem with JDBC Connection or Execution");
        OjvmWCUExceptionTable.put(14, "LoadJava Exception");
        OjvmWCUExceptionTable.put(15, "OjvmWCU Cannot procced Further!!!");
        OjvmWCUExceptionTable.put(16, "Required Class Not Found");
    }

    public OjvmWCUException(int errCode, OjvmWCUInputParameters inp, Exception e) {
        super("Exception : WCU-0" + errCode + "00 \n " + OjvmWCUExceptionTable.get(errCode));
        this.errorCode = errCode;
        if (inp != null && inp.OjvmWCUVerbose.booleanValue() && e != null) {
            inp.OWCULogger.finest(e.getStackTrace() + "");
        }
    }

    public OjvmWCUException(int errCode, String addMess, OjvmWCUInputParameters inp, Exception e) {
        super("Exception : WCU-0" + errCode + "00 \n " + OjvmWCUExceptionTable.get(errCode) + " : " + addMess);
        this.errorCode = errCode;
        this.additionalMessage = addMess;
        if (inp != null && inp.OjvmWCUVerbose.booleanValue() && e != null) {
            inp.OWCULogger.finest(e.getStackTrace() + "");
        }
    }

    public OjvmWCUException(OjvmWCUInputParameters inp, Exception e) {
        super("Exception : WCU-0000");
        this.errorCode = 0;
        if (inp != null && inp.OjvmWCUVerbose.booleanValue() && e != null) {
            inp.OWCULogger.finest(e.getStackTrace() + "");
        }
    }

    static {
        OjvmWCUException.generateTable();
    }
}

