/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.ojvmwcu;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUException;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUInputParameters;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUUtils;
import sun.security.util.SecurityConstants;

public class OjvmWCUWrappers {
    OjvmWCUInputParameters inpPar = null;
    ArrayList<PlsqlType> typeArrayList = new ArrayList();
    ArrayList<String> prePlsqlWrapper = new ArrayList();
    ArrayList<String> allMethodNameArray = new ArrayList();
    private String readmeTemplate = "Readme.txt";
    private String enumTemplate = "enumTemplate.txt";
    private String grabAndSaveCertificateProcedureName = "grabAndSaveCertificate";
    private String credProcedureName = "setCredentials";
    HashMap<String, Integer> usedVariableNames;
    static HashMap<String, String> dataTypeMapJ2P = new HashMap();
    static URLClassLoader generatedClassLoader;

    public OjvmWCUWrappers(OjvmWCUInputParameters in) {
        this.inpPar = in;
    }

    private String getRelativePath(File dir, File file) {
        int indDir;
        int stInd;
        String dirName = dir.getAbsolutePath();
        String fileName = file.getAbsolutePath();
        String tempRelPath = fileName.substring(stInd = (indDir = fileName.indexOf(dirName)) + dirName.length());
        if (tempRelPath.startsWith("/") || tempRelPath.startsWith("\\")) {
            return tempRelPath.substring(1);
        }
        return tempRelPath;
    }

    public Boolean createJar(JarOutputStream jis, File dirName, String baseDir, ArrayList<File> fileList) throws OjvmWCUException {
        File file = new File(baseDir);
        String relString = this.getRelativePath(file, dirName);
        String modRelString = relString.replace("\\", "/");
        if (dirName.isDirectory()) {
            modRelString = modRelString + "/";
            File[] dirList = dirName.listFiles();
            for (int i = 0; i < dirList.length; ++i) {
                this.createJar(jis, dirList[i], baseDir, fileList);
            }
        } else if (dirName.getName().endsWith(".class") || dirName.getName().endsWith(".properties")) {
            BufferedInputStream in;
            JarEntry jE = new JarEntry(relString);
            try {
                if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
                    this.inpPar.OWCULogger.info("Adding Entry - " + dirName.getName());
                }
                jis.putNextEntry(jE);
            }
            catch (IOException ex) {
                throw new OjvmWCUException(5, "Cannot create Jar Entry", this.inpPar, ex);
            }
            try {
                in = new BufferedInputStream(new FileInputStream(dirName));
            }
            catch (FileNotFoundException ex) {
                throw new OjvmWCUException(5, "Cannot find file " + dirName, this.inpPar, ex);
            }
            byte[] fileBuffer = new byte[1024];
            int readBytes = 0;
            try {
                while ((readBytes = in.read(fileBuffer)) != -1) {
                    jis.write(fileBuffer, 0, readBytes);
                }
            }
            catch (IOException ioe) {
                throw new OjvmWCUException(5, "Exception reading input from file " + dirName, this.inpPar, ioe);
            }
            try {
                jis.closeEntry();
            }
            catch (IOException ex) {
                throw new OjvmWCUException(5, "Exception closing jar Entry for " + dirName, this.inpPar, ex);
            }
        }
        return Boolean.TRUE;
    }

    String getNewPlsqlMethodName(String methodName) {
        String newMethodName = methodName;
        if (methodName.length() > 25) {
            newMethodName = methodName.substring(0, 25);
        }
        int cnt = 1;
        Boolean foundUniqueName = Boolean.FALSE;
        String uniqueName = newMethodName;
        block0: while (!foundUniqueName.booleanValue()) {
            foundUniqueName = Boolean.TRUE;
            for (int i = 0; i < this.allMethodNameArray.size(); ++i) {
                if (!this.allMethodNameArray.get(i).equalsIgnoreCase(uniqueName)) continue;
                uniqueName = newMethodName + "_" + cnt;
                ++cnt;
                foundUniqueName = Boolean.FALSE;
                continue block0;
            }
        }
        this.allMethodNameArray.add(uniqueName);
        return uniqueName;
    }

    public Boolean generatePLSQLWrappers(ArrayList<Method> methodList, String fileName, ClassLoader customClassLoader) throws OjvmWCUException {
        try {
            ArrayList<String> plsqlWrapperPackageDefn = new ArrayList<String>();
            ArrayList<String> plsqlWrapperPackageBody = new ArrayList<String>();
            this.inpPar.webServiceCleanup.add("DROP PACKAGE " + this.inpPar.nameOfWebService);
            this.inpPar.webServiceCleanup.add("/");
            plsqlWrapperPackageDefn.add("CREATE OR REPLACE PACKAGE " + this.inpPar.nameOfWebService + " AS ");
            plsqlWrapperPackageBody.add("CREATE OR REPLACE PACKAGE BODY " + this.inpPar.nameOfWebService + " IS");
            for (int i = 0; i < methodList.size(); ++i) {
                Method methodUnderConsideration = methodList.get(i);
                if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
                    this.inpPar.OWCULogger.info("Processing Mehtod " + methodUnderConsideration.getName());
                }
                String plsqlFuncName = this.getNewPlsqlMethodName(methodUnderConsideration.getName());
                Class<?> retType = null;
                String callerStringName = "";
                String methodLineDefnName = "";
                String methodLineBodyPartName = "";
                Boolean isFunction = Boolean.FALSE;
                methodLineBodyPartName = methodLineBodyPartName + this.inpPar.packageName + "." + this.inpPar.nameOfWebService + "." + methodUnderConsideration.getName();
                callerStringName = callerStringName + this.inpPar.nameOfWebService + "." + plsqlFuncName;
                if (methodUnderConsideration.getReturnType() != null && !methodUnderConsideration.getReturnType().getName().equalsIgnoreCase("void")) {
                    methodLineDefnName = methodLineDefnName + " FUNCTION " + plsqlFuncName;
                    retType = methodUnderConsideration.getReturnType();
                    isFunction = Boolean.TRUE;
                } else {
                    methodLineDefnName = methodLineDefnName + " PROCEDURE " + plsqlFuncName + " ";
                }
                Class<?>[] argsOfFunction = methodUnderConsideration.getParameterTypes();
                String callerStringArg = "";
                String methodLineDefnArg = "";
                String methodLineBodyPartArg = "";
                Type[] argTypesOfFunction = methodUnderConsideration.getGenericParameterTypes();
                for (int j = 0; j < argsOfFunction.length; ++j) {
                    String javaParType;
                    Class<?> argUnderConsideration = argsOfFunction[j];
                    Type argTypeUnderConsideration = argTypesOfFunction[j];
                    String plsqlParType = "";
                    Boolean typeIsHolder = Boolean.FALSE;
                    if (argUnderConsideration.getName().equals("javax.xml.ws.Holder")) {
                        Type holder_value_type;
                        typeIsHolder = Boolean.TRUE;
                        argTypeUnderConsideration = holder_value_type = ((ParameterizedType)argTypeUnderConsideration).getActualTypeArguments()[0];
                        if (holder_value_type instanceof ParameterizedType) {
                            holder_value_type = ((ParameterizedType)holder_value_type).getRawType();
                        }
                        argUnderConsideration = Class.forName(holder_value_type.getTypeName(), true, customClassLoader);
                    }
                    if ((javaParType = argUnderConsideration.getName().replaceAll("\\$", ".")).equals("[B")) {
                        javaParType = "oracle.sql.RAW";
                    }
                    if ((plsqlParType = dataTypeMapJ2P.get(argUnderConsideration.getName())) == null) {
                        PlsqlType thisType = this.checkAndCreateNewType(argUnderConsideration, argUnderConsideration.getSimpleName(), argTypeUnderConsideration, customClassLoader);
                        plsqlParType = thisType.newPlsqlTypeName;
                        javaParType = thisType.isArrayType != false ? "oracle.sql.ARRAY" : "oracle.sql.STRUCT";
                    }
                    if (typeIsHolder.booleanValue()) {
                        methodLineDefnArg = methodLineDefnArg + "arg_holder" + j + " IN OUT " + plsqlParType;
                        methodLineBodyPartArg = methodLineBodyPartArg + javaParType + "[]";
                    } else {
                        methodLineDefnArg = methodLineDefnArg + "arg" + j + " " + plsqlParType;
                        methodLineBodyPartArg = methodLineBodyPartArg + javaParType;
                    }
                    callerStringArg = callerStringArg + plsqlParType;
                    if (j == argsOfFunction.length - 1) continue;
                    methodLineDefnArg = methodLineDefnArg + ", ";
                    methodLineBodyPartArg = methodLineBodyPartArg + ", ";
                    callerStringArg = callerStringArg + ", ";
                }
                String methodLineDefnReturnType = "";
                String methodLineBodyPartReturnType = "";
                String plsqlRetType = null;
                if (isFunction.booleanValue()) {
                    Type retClassType = methodUnderConsideration.getGenericReturnType();
                    String javaRetType = methodUnderConsideration.getReturnType().getName().replaceAll("\\$", ".");
                    if (javaRetType.equals("[B")) {
                        javaRetType = "java.sql.Array";
                    }
                    if ((plsqlRetType = dataTypeMapJ2P.get(retType.getName())) == null) {
                        PlsqlType thisType = this.checkAndCreateNewType(retType, retType.getSimpleName(), retClassType, customClassLoader);
                        plsqlRetType = thisType.newPlsqlTypeName;
                        javaRetType = thisType.isArrayType != false ? "java.sql.Array" : "java.sql.Struct";
                    }
                    methodLineDefnReturnType = methodLineDefnReturnType + " RETURN " + plsqlRetType;
                    methodLineBodyPartReturnType = methodLineBodyPartReturnType + " return " + javaRetType;
                }
                if (!methodLineDefnArg.equals("")) {
                    methodLineDefnArg = "(" + methodLineDefnArg + ")";
                }
                methodLineBodyPartArg = "(" + methodLineBodyPartArg + ")";
                if (!callerStringArg.equals("")) {
                    callerStringArg = "(" + callerStringArg + ")";
                }
                String methodLineDefn = methodLineDefnName + methodLineDefnArg + methodLineDefnReturnType;
                String methodLineBodyPart = methodLineBodyPartName + methodLineBodyPartArg + methodLineBodyPartReturnType;
                String callerString = callerStringName + callerStringArg;
                String methodLineBody = methodLineDefn;
                methodLineDefn = methodLineDefn + ";";
                methodLineBody = methodLineBody + "\n as language java name '";
                methodLineBody = methodLineBody + methodLineBodyPart + "';";
                plsqlWrapperPackageDefn.add(methodLineDefn);
                plsqlWrapperPackageBody.add(methodLineBody);
                this.inpPar.operationHelper.put(callerStringName + callerStringArg, plsqlRetType);
                if (!isFunction.booleanValue()) continue;
                if (retType == String.class) {
                    methodLineDefn = methodLineDefnName + "_Clob" + methodLineDefnArg + " RETURN CLOB";
                    methodLineBodyPart = methodLineBodyPartName + "_Clob" + methodLineBodyPartArg + " return java.sql.Clob";
                    callerString = callerStringName + "_Clob" + callerStringArg + " ";
                    methodLineBody = methodLineDefn;
                    methodLineDefn = methodLineDefn + ";";
                    methodLineBody = methodLineBody + "\n as language java name '";
                    methodLineBody = methodLineBody + methodLineBodyPart + "';";
                    plsqlWrapperPackageDefn.add(methodLineDefn);
                    plsqlWrapperPackageBody.add(methodLineBody);
                    this.inpPar.operationHelper.put(callerString, "CLOB");
                    continue;
                }
                if (!retType.getName().equals("[B")) continue;
                methodLineDefn = methodLineDefnName + "_Blob" + methodLineDefnArg + " RETURN BLOB";
                methodLineBodyPart = methodLineBodyPartName + "_Blob" + methodLineBodyPartArg + " return java.sql.Blob";
                callerString = callerStringName + "_Blob" + callerStringArg + " ";
                methodLineBody = methodLineDefn;
                methodLineDefn = methodLineDefn + ";";
                methodLineBody = methodLineBody + "\n as language java name '";
                methodLineBody = methodLineBody + methodLineBodyPart + "';";
                plsqlWrapperPackageDefn.add(methodLineDefn);
                plsqlWrapperPackageBody.add(methodLineBody);
                this.inpPar.operationHelper.put(callerString, "BLOB");
            }
            plsqlWrapperPackageDefn.add("PROCEDURE " + this.credProcedureName + "(usr VARCHAR2, pwd VARCHAR2);");
            plsqlWrapperPackageDefn.add("PROCEDURE " + this.grabAndSaveCertificateProcedureName + "(host VARCHAR2, port VARCHAR2);");
            plsqlWrapperPackageBody.add("PROCEDURE " + this.credProcedureName + "(usr VARCHAR2, pwd VARCHAR2) AS LANGUAGE java NAME ");
            plsqlWrapperPackageBody.add("'oracle.ojvmwcu.security.Utils.setCredentials(java.lang.String, java.lang.String)';");
            this.inpPar.operationHelper.put(this.inpPar.nameOfWebService + "." + this.credProcedureName + "(VARCHAR2 user, VARCHAR2 Password)", null);
            plsqlWrapperPackageBody.add("PROCEDURE " + this.grabAndSaveCertificateProcedureName + "(host VARCHAR2, port VARCHAR2) AS LANGUAGE java NAME ");
            plsqlWrapperPackageBody.add("'oracle.ojvmwcu.security.Utils.grabAndSaveCertificate(java.lang.String, java.lang.String)';");
            this.inpPar.operationHelper.put(this.inpPar.nameOfWebService + "." + this.grabAndSaveCertificateProcedureName + "(VARCHAR2 host, VARCHAR2 port)", null);
            plsqlWrapperPackageDefn.add("END " + this.inpPar.nameOfWebService + ";");
            plsqlWrapperPackageBody.add("END " + this.inpPar.nameOfWebService + ";");
            plsqlWrapperPackageDefn.add("/");
            plsqlWrapperPackageBody.add("/");
            this.inpPar.webServiceWrapperContents.addAll(this.prePlsqlWrapper);
            this.inpPar.webServiceWrapperContents.addAll(plsqlWrapperPackageDefn);
            this.inpPar.webServiceWrapperContents.addAll(plsqlWrapperPackageBody);
            OjvmWCUUtils.writeToFile(fileName, this.inpPar.webServiceWrapperContents, this.inpPar);
        }
        catch (OjvmWCUException oe) {
            throw oe;
        }
        catch (Exception e) {
            throw new OjvmWCUException(2, "Exception Generating wrappers", this.inpPar, e);
        }
        return Boolean.TRUE;
    }

    PlsqlType createArrayTypePlsqlType(Boolean isComplexType, Class genericClassInfo, PlsqlType genericType) throws OjvmWCUException {
        PlsqlType retType = new PlsqlType();
        retType.isArrayType = Boolean.TRUE;
        retType.isComplexArrayType = isComplexType;
        retType.innerGenericClass = genericClassInfo;
        retType.innerGenericType = genericType;
        try {
            retType.classInfo = Class.forName("java.util.List");
        }
        catch (ClassNotFoundException cnfEx) {
            throw new OjvmWCUException(16, this.inpPar, cnfEx);
        }
        retType.fields = null;
        String typeName = isComplexType != false ? genericType.newPlsqlTypeName + "Array" : "Java" + genericClassInfo.getSimpleName() + "Array";
        retType.newPlsqlTypeName = this.getNewPlsqlTypeName(typeName);
        this.inpPar.webServiceCleanup.add("DROP TYPE " + retType.newPlsqlTypeName + " FORCE;");
        this.inpPar.webServiceCleanup.add("/");
        String typeOfNewVar = isComplexType != false ? genericType.newPlsqlTypeName : this.getFullTypeName(dataTypeMapJ2P.get(genericClassInfo.getName()));
        retType.typeDefnString.add("CREATE OR REPLACE TYPE " + retType.newPlsqlTypeName + " IS VARRAY (100) OF " + typeOfNewVar + ";");
        retType.typeDefnString.add("/");
        for (int tdscnt = 0; tdscnt < retType.typeDefnString.size(); ++tdscnt) {
            this.prePlsqlWrapper.add(retType.typeDefnString.get(tdscnt));
            this.inpPar.newTypesCreate.add(retType.typeDefnString.get(tdscnt));
        }
        return retType;
    }

    Class getGenericClassFromGenericType(Type typeName, ClassLoader customClassLoader) throws OjvmWCUException {
        ParameterizedType pType = (ParameterizedType)typeName;
        String retTypeString = pType.getActualTypeArguments()[0].toString();
        String genericClassName = retTypeString.substring(retTypeString.indexOf(" ") + 1);
        Class<?> genericClass = null;
        try {
            genericClass = Class.forName(genericClassName, true, customClassLoader);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new OjvmWCUException(16, this.inpPar, cnfEx);
        }
        return genericClass;
    }

    String getNewPlsqlTypeName(String typeName) {
        String plsqlTypeName = typeName;
        if (typeName.startsWith("_")) {
            plsqlTypeName = typeName.substring(1) + "_";
        }
        if (plsqlTypeName.length() >= 25) {
            char[] charArr = plsqlTypeName.toCharArray();
            String newStr = "";
            for (int i = 0; i < charArr.length; ++i) {
                if (!Character.isUpperCase(charArr[i])) continue;
                newStr = newStr + charArr[i];
            }
            plsqlTypeName = newStr;
        }
        if (plsqlTypeName.length() >= 25) {
            plsqlTypeName = plsqlTypeName.substring(0, 25);
        }
        Boolean findNew = Boolean.TRUE;
        Boolean varMod = Boolean.FALSE;
        String addNoTypeName = plsqlTypeName;
        int no = 1;
        while (findNew.booleanValue()) {
            for (int i = 0; i < this.typeArrayList.size(); ++i) {
                if (!this.typeArrayList.get((int)i).newPlsqlTypeName.equalsIgnoreCase(plsqlTypeName)) continue;
                plsqlTypeName = plsqlTypeName + "_" + no;
                ++no;
                varMod = Boolean.TRUE;
                break;
            }
            if (varMod.booleanValue()) continue;
        }
        if (!plsqlTypeName.startsWith("OBJ_")) {
            plsqlTypeName = "OBJ_" + plsqlTypeName;
        }
        return plsqlTypeName;
    }

    PlsqlType checkAndCreateNewType(Class thisClass, String typeName, Type typeOfArg, ClassLoader customClassLoader) throws OjvmWCUException {
        XmlEnum enumAnnotation;
        String newTypeName;
        if (thisClass.getName().equalsIgnoreCase("java.util.List")) {
            Class innerGenericClass = this.getGenericClassFromGenericType(typeOfArg, customClassLoader);
            for (int i = 0; i < this.typeArrayList.size(); ++i) {
                PlsqlType currPlsqlType = this.typeArrayList.get(i);
                if (!currPlsqlType.isArrayType.booleanValue() || !currPlsqlType.innerGenericClass.equals(innerGenericClass)) continue;
                return currPlsqlType;
            }
            String typeMap = dataTypeMapJ2P.get(innerGenericClass.getName());
            if (typeMap == null || typeMap.equals("")) {
                PlsqlType innerType = this.checkAndCreateNewType(innerGenericClass, innerGenericClass.getSimpleName(), null, customClassLoader);
                PlsqlType newArrType = this.createArrayTypePlsqlType(Boolean.TRUE, innerGenericClass, innerType);
                this.typeArrayList.add(newArrType);
                return newArrType;
            }
            PlsqlType newArrType = this.createArrayTypePlsqlType(Boolean.FALSE, innerGenericClass, null);
            this.typeArrayList.add(newArrType);
            return newArrType;
        }
        for (int i = 0; i < this.typeArrayList.size(); ++i) {
            PlsqlType thisFieldFromList = this.typeArrayList.get(i);
            if (!thisClass.getSimpleName().equals(thisFieldFromList.classInfo.getSimpleName()) || !thisClass.equals(thisFieldFromList.classInfo)) continue;
            return thisFieldFromList;
        }
        PlsqlType ptype = new PlsqlType();
        ptype.newPlsqlTypeName = newTypeName = this.getNewPlsqlTypeName(typeName);
        ptype.className = typeName;
        ptype.classInfo = thisClass;
        ArrayList<String> thisTypeStringArrList = new ArrayList<String>();
        this.inpPar.webServiceCleanup.add("DROP TYPE " + newTypeName + " FORCE");
        this.inpPar.webServiceCleanup.add("/");
        thisTypeStringArrList.add("CREATE OR REPLACE TYPE " + newTypeName + " AS OBJECT (");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
        }
        this.checkPackageAccess(thisClass);
        if (Modifier.isAbstract(thisClass.getModifiers())) {
            thisTypeStringArrList.add("dummy_ VARCHAR2(4000)");
        }
        if ((enumAnnotation = thisClass.getAnnotation(XmlEnum.class)) != null) {
            this.inpPar.enumNameArray.add(thisClass.getSimpleName());
            thisTypeStringArrList.add("value_ VARCHAR2(4000));");
        } else {
            Field[] allFields = thisClass.getDeclaredFields();
            for (int i = 0; i < allFields.length; ++i) {
                Field thisField = allFields[i];
                String fieldName = "arg" + i;
                ptype.fields.put(thisField.getName(), thisField);
                String type = dataTypeMapJ2P.get(thisField.getType().getCanonicalName());
                String finType = "";
                if (type == null || type.equals("")) {
                    PlsqlType thisPl = this.checkAndCreateNewType(thisField.getType(), this.getSimpleNameFromCanonicalName(thisField.getType().getTypeName()), thisField.getGenericType(), customClassLoader);
                    finType = thisPl.newPlsqlTypeName;
                } else {
                    finType = this.getFullTypeName(type);
                }
                if (i != allFields.length - 1) {
                    thisTypeStringArrList.add(fieldName + " " + finType + ", ");
                    continue;
                }
                thisTypeStringArrList.add(fieldName + " " + finType + "); ");
            }
            if (allFields.length == 0) {
                thisTypeStringArrList.add("); ");
            }
        }
        thisTypeStringArrList.add("/");
        ptype.typeDefnString = thisTypeStringArrList;
        this.typeArrayList.add(ptype);
        for (int i = 0; i < ptype.typeDefnString.size(); ++i) {
            this.prePlsqlWrapper.add(ptype.typeDefnString.get(i));
            this.inpPar.newTypesCreate.add(ptype.typeDefnString.get(i));
        }
        return ptype;
    }

    String getSimpleNameFromCanonicalName(String canonicalName) {
        if (canonicalName.contains(".") && canonicalName.lastIndexOf(46) < canonicalName.length() - 1) {
            return canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
        }
        return "Error";
    }

    String getFullTypeName(String type) {
        if (type.equals("NUMBER")) {
            return "NUMBER(10)";
        }
        if (type.equals("VARCHAR2")) {
            return "VARCHAR2(100)";
        }
        return type;
    }

    public Boolean compileJavaClass(String file, String[] classPath) throws OjvmWCUException {
        try {
            JavaCompiler x = ToolProvider.getSystemJavaCompiler();
            String[] classPathVariable = new String[3];
            classPathVariable[0] = file;
            classPathVariable[1] = "-cp";
            String fullCp = "";
            for (int i = 0; i < classPath.length; ++i) {
                fullCp = fullCp + classPath[i] + System.getProperty("path.separator");
            }
            classPathVariable[2] = fullCp;
            if (x != null) {
                x.run(null, null, null, classPathVariable);
            } else {
                String javacPath = this.inpPar.jdkHome + "/bin/javac";
                String[] javacArgs = new String[classPathVariable.length + 1];
                javacArgs[0] = javacPath;
                for (int i = 0; i < classPathVariable.length; ++i) {
                    javacArgs[i + 1] = classPathVariable[i];
                }
                ProcessBuilder javacProcess = new ProcessBuilder(javacArgs);
                Process p = javacProcess.start();
                OutputStream out = p.getOutputStream();
                InputStream err = p.getErrorStream();
                BufferedReader ebr = new BufferedReader(new InputStreamReader(err));
                if (ebr.readLine() != null) {
                    throw new OjvmWCUException(6, "Error running Javac tool", this.inpPar, null);
                }
                p.waitFor();
                p.destroy();
            }
        }
        catch (Exception e) {
            throw new OjvmWCUException(6, file + "\nA common reason is JDBC Driver not in CLASSPATH\nEither set CLASSPATH or use -cp with JDBC Driver\n", this.inpPar, e);
        }
        return Boolean.TRUE;
    }

    private void checkPackageAccess(Class clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            int i;
            int b;
            sm.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
            String cname = clazz.getName().replace('/', '.');
            if (cname.startsWith("[") && (b = cname.lastIndexOf(91) + 2) > 1 && b < cname.length()) {
                cname = cname.substring(b);
            }
            if ((i = cname.lastIndexOf(46)) != -1) {
                sm.checkPackageAccess(cname.substring(0, i));
            }
        }
    }

    public String getAccessorObject(Method methodUnderConsiderationCallie) throws OjvmWCUException {
        String retString = "";
        URLClassLoader cl = this.getGeneratedClassLoader();
        File[] dir = this.getGeneratedFiles(this.getPackagePath());
        try {
            for (int fno = 0; fno < dir.length; ++fno) {
                if (!dir[fno].isFile() || !dir[fno].getName().endsWith(".class")) continue;
                String fileNameOnly = dir[fno].getName().substring(0, dir[fno].getName().indexOf(".class"));
                String loadingClassName = this.inpPar.packageName + "." + fileNameOnly;
                Class<?> webServiceClientClass = cl.loadClass(loadingClassName);
                WebServiceClient webServiceClientCl = webServiceClientClass.getAnnotation(WebServiceClient.class);
                if (webServiceClientCl == null) continue;
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
                }
                this.checkPackageAccess(webServiceClientClass);
                Method[] classMethods = webServiceClientClass.getMethods();
                for (int i = 0; i < classMethods.length; ++i) {
                    Method methodUnderConsideration = classMethods[i];
                    WebEndpoint webEndPointMethod = methodUnderConsideration.getAnnotation(WebEndpoint.class);
                    if (webEndPointMethod == null || methodUnderConsideration.getParameterTypes().length != 0) continue;
                    String webServiceClassName = methodUnderConsideration.getReturnType().getName();
                    Class<?> webServiceClass = cl.loadClass(webServiceClassName);
                    Method[] webEndPoints = webServiceClass.getDeclaredMethods();
                    for (int j = 0; j < webEndPoints.length; ++j) {
                        if (!methodUnderConsiderationCallie.equals(webEndPoints[j])) continue;
                        String methodName = methodUnderConsideration.getName();
                        String className = webServiceClientClass.getName();
                        return "new " + className + "()." + methodName + "()";
                    }
                }
            }
        }
        catch (ClassNotFoundException ce) {
            throw new OjvmWCUException(8, this.inpPar, ce);
        }
        catch (Exception e) {
            throw new OjvmWCUException(2, "Get Accessor ", this.inpPar, e);
        }
        return retString;
    }

    public Boolean generateJavaSrcJAXRS(ArrayList<Method> methodList, String fileName, String javaSrcKeepFileName, ClassLoader customClassLoader) throws OjvmWCUException {
        String javaMethodBody = "";
        String javaMethodName = "";
        String javaSizeWrapperMethodBody = "";
        ArrayList<String> javaSrc = new ArrayList<String>();
        javaSrc.add("package " + this.inpPar.packageName + ";");
        javaSrc.add("");
        javaSrc.add("import oracle.ojvmwcu.security.Utils;");
        javaSrc.add("import oracle.ojvmwcu.conversion.ConversionUtils;");
        javaSrc.add("import java.sql.*;");
        javaSrc.add("import javax.ws.rs.client.Client;");
        javaSrc.add("import javax.ws.rs.client.ClientBuilder;");
        javaSrc.add("");
        javaSrc.add("class " + this.inpPar.nameOfWebService + "{");
        for (int i = 0; i < methodList.size(); ++i) {
            javaMethodBody = "\tpublic static String ";
            javaSizeWrapperMethodBody = "\tpublic static Clob ";
            javaMethodName = "";
            Method methodUnderConsideration = methodList.get(i);
            String accessor = methodUnderConsideration.getDeclaringClass().getName();
            String parameterType = methodUnderConsideration.getParameterTypes()[0].getSimpleName();
            StringTokenizer token = new StringTokenizer(accessor, "$");
            String call = "";
            if (token.hasMoreTokens()) {
                call = call + token.nextToken();
                boolean base_resource = true;
                while (token.hasMoreTokens()) {
                    String resource = token.nextToken();
                    javaMethodName = javaMethodName + resource;
                    if (base_resource) {
                        call = call + "." + resource.toLowerCase() + "(client)";
                        base_resource = false;
                    } else {
                        call = call + "." + resource.toLowerCase() + "()";
                    }
                    if (!token.hasMoreTokens()) continue;
                    javaMethodName = javaMethodName + "_";
                }
            }
            String method = methodUnderConsideration.getName();
            javaMethodName = javaMethodName + "_" + method + "_" + parameterType.toLowerCase();
            javaMethodBody = javaMethodBody + javaMethodName + "(){";
            javaMethodBody = javaMethodBody + "\n\t\tif(Utils.isSetCredentials) {\n\t\t\tUtils.setDefaultAuthenticator();\n\t\t}";
            javaMethodBody = javaMethodBody + "\n\t\tClient client = ClientBuilder.newBuilder().sslContext(Utils.getSSLContext()).build();";
            call = call + "." + method + "(String.class);";
            call = "\n\t\treturn " + call;
            javaMethodBody = javaMethodBody + call + "\n\t}";
            javaSrc.add("");
            javaSrc.add(javaMethodBody);
            javaSizeWrapperMethodBody = javaSizeWrapperMethodBody + javaMethodName + "_Clob(){";
            javaSizeWrapperMethodBody = javaSizeWrapperMethodBody + "\n\t\treturn ConversionUtils.toClob(" + javaMethodName + "());\n\t}";
            javaSrc.add("");
            javaSrc.add(javaSizeWrapperMethodBody);
        }
        javaSrc.add("}");
        OjvmWCUUtils.writeToFile(fileName, javaSrc, this.inpPar);
        if (this.inpPar.keepSrc.booleanValue()) {
            OjvmWCUUtils.writeToFile(javaSrcKeepFileName, javaSrc, this.inpPar);
        }
        return Boolean.TRUE;
    }

    public Boolean generateEnumJavaSrc(ArrayList<Method> methodList, String packagePath, ClassLoader customClassLoader) throws OjvmWCUException {
        for (String enumName : this.inpPar.enumNameArray) {
            String curline = null;
            ArrayList<String> enumJavaSrc = new ArrayList<String>();
            try {
                InputStream in = this.getClass().getResourceAsStream(this.enumTemplate);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((curline = br.readLine()) != null) {
                    curline = curline.replace("PACKAGENAME", this.inpPar.packageName);
                    curline = curline.replace("ENUMNAME", enumName);
                    enumJavaSrc.add(curline);
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean result = OjvmWCUUtils.writeToFile(this.inpPar.tmpDirectory + "/" + packagePath + "/" + enumName + "Class.java", enumJavaSrc, this.inpPar);
            if (!this.inpPar.keepSrc.booleanValue()) continue;
            result = OjvmWCUUtils.writeToFile(this.inpPar.outputDirectory + "/" + packagePath + "/" + enumName + "Class.java", enumJavaSrc, this.inpPar);
        }
        return true;
    }

    public Boolean generateJavaSrc(ArrayList<Method> methodList, String fileName, String javaSrcKeepFileName, ClassLoader customClassLoader) throws OjvmWCUException {
        try {
            ArrayList<String> javaSrc = new ArrayList<String>();
            javaSrc.add("package " + this.inpPar.packageName + ";");
            javaSrc.add("import oracle.ojvmwcu.security.Utils;");
            javaSrc.add("import oracle.ojvmwcu.conversion.ConversionUtils;");
            javaSrc.add("import java.sql.*;");
            javaSrc.add("\nclass " + this.inpPar.nameOfWebService + "{");
            for (int i = 0; i < methodList.size(); ++i) {
                Method methodUnderConsideration = methodList.get(i);
                this.usedVariableNames = new HashMap();
                String accessorObj = this.getAccessorObject(methodUnderConsideration);
                String retTypeToSig = methodUnderConsideration.getReturnType().getName();
                Class<?> retTypeClass = methodUnderConsideration.getReturnType();
                Type retTypeType = methodUnderConsideration.getGenericReturnType();
                Boolean isComplexRetType = Boolean.FALSE;
                PlsqlType complexRetTypePlsqlType = null;
                if (retTypeClass.getName().equals("[B")) {
                    retTypeToSig = "byte[]";
                } else if (dataTypeMapJ2P.get(retTypeClass.getName()) == null && !retTypeClass.getName().equalsIgnoreCase("void")) {
                    isComplexRetType = Boolean.TRUE;
                    for (int cnt = 0; cnt < this.typeArrayList.size(); ++cnt) {
                        if (retTypeClass.getName().equalsIgnoreCase("java.util.List")) {
                            Class arrayElementType = this.getGenericClassFromGenericType(retTypeType, customClassLoader);
                            if (!this.typeArrayList.get((int)cnt).isArrayType.booleanValue() || !this.typeArrayList.get((int)cnt).innerGenericClass.getName().equals(arrayElementType.getName())) continue;
                            complexRetTypePlsqlType = this.typeArrayList.get(cnt);
                            break;
                        }
                        if (!this.typeArrayList.get((int)cnt).classInfo.getName().equals(retTypeClass.getName())) continue;
                        complexRetTypePlsqlType = this.typeArrayList.get(cnt);
                        break;
                    }
                }
                if (isComplexRetType.booleanValue()) {
                    retTypeToSig = complexRetTypePlsqlType.isArrayType != false ? "java.sql.Array" : "java.sql.Struct";
                }
                String functionSignature = "\n\tpublic static " + retTypeToSig.replaceAll("\\$", ".") + " " + methodUnderConsideration.getName();
                String functionCaller = methodUnderConsideration.getName();
                Class<?>[] argsOfFunction = methodUnderConsideration.getParameterTypes();
                Type[] genericTypesOfArgs = methodUnderConsideration.getGenericParameterTypes();
                ArrayList<String> preObjectInit = new ArrayList<String>();
                ArrayList<String> postFunctionCall = new ArrayList<String>();
                String argsInSignature = "";
                String argsInfunctionCaller = "";
                Boolean connObjHolderReq = Boolean.FALSE;
                for (int j = 0; j < argsOfFunction.length; ++j) {
                    Type genericInnerType = genericTypesOfArgs[j];
                    Class<?> thisArgClass = argsOfFunction[j];
                    Boolean typeIsHolder = Boolean.FALSE;
                    if (thisArgClass.getName().equals("javax.xml.ws.Holder")) {
                        Type holder_value_type;
                        typeIsHolder = Boolean.TRUE;
                        genericInnerType = holder_value_type = ((ParameterizedType)genericInnerType).getActualTypeArguments()[0];
                        if (holder_value_type instanceof ParameterizedType) {
                            holder_value_type = ((ParameterizedType)holder_value_type).getRawType();
                        }
                        thisArgClass = Class.forName(holder_value_type.getTypeName(), Boolean.TRUE, customClassLoader);
                    }
                    String thisArgType = thisArgClass.getName();
                    String modArgType = dataTypeMapJ2P.get(thisArgType);
                    String thisArgName = "arg" + j;
                    if (typeIsHolder.booleanValue()) {
                        thisArgName = "arg_holder_" + j;
                    }
                    String thisArgNameFull = thisArgName;
                    if (thisArgClass.getName().equals("[B")) {
                        thisArgType = "oracle.sql.RAW";
                        if (typeIsHolder.booleanValue()) {
                            preObjectInit.add("\t\t" + genericTypesOfArgs[j].getTypeName() + " holder_" + thisArgNameFull + " = new " + genericTypesOfArgs[j].getTypeName() + "(" + thisArgNameFull + "[0].getBytes());");
                            postFunctionCall.add("\t\t" + thisArgNameFull + "[0] = holder_" + thisArgNameFull + ".value;");
                            argsInfunctionCaller = argsInfunctionCaller + "holder_" + thisArgNameFull;
                            argsInSignature = argsInSignature + thisArgType + "[] " + thisArgName;
                        } else {
                            thisArgNameFull = thisArgNameFull + ".getBytes()";
                        }
                    } else if (modArgType == null || modArgType.equals("")) {
                        int k;
                        PlsqlType pltype = null;
                        if (thisArgType.equalsIgnoreCase("java.util.List")) {
                            for (k = 0; k < this.typeArrayList.size(); ++k) {
                                PlsqlType currType = this.typeArrayList.get(k);
                                if (!currType.isArrayType.booleanValue() || !currType.innerGenericClass.equals(this.getGenericClassFromGenericType(genericInnerType, customClassLoader))) continue;
                                pltype = currType;
                                thisArgType = "oracle.sql.ARRAY";
                                thisArgNameFull = "Array_" + thisArgName;
                                break;
                            }
                        } else {
                            for (k = 0; k < this.typeArrayList.size(); ++k) {
                                pltype = this.typeArrayList.get(k);
                                if (pltype.classInfo.getName().equals(thisArgClass.getName())) break;
                            }
                            thisArgNameFull = this.getUnUsedVariableName("Class_" + thisArgName);
                            thisArgType = "oracle.sql.STRUCT";
                        }
                        if (typeIsHolder.booleanValue()) {
                            connObjHolderReq = Boolean.TRUE;
                            preObjectInit.addAll(this.getObjectConstructionCode(pltype, thisArgName + "[0]", thisArgNameFull, Boolean.FALSE, null, null, null, customClassLoader));
                            preObjectInit.add("\t\t" + genericTypesOfArgs[j].getTypeName() + " holder_" + thisArgNameFull + " = new " + genericTypesOfArgs[j].getTypeName() + "(" + thisArgNameFull + ");");
                            argsInfunctionCaller = argsInfunctionCaller + "holder_" + thisArgNameFull;
                            argsInSignature = argsInSignature + thisArgType + "[] " + thisArgName;
                            postFunctionCall.add("\t\t" + thisArgNameFull + " = holder_" + thisArgNameFull + ".value;");
                            postFunctionCall.addAll(this.getPlsqlReturnObjectCode(pltype, thisArgNameFull, null, "holder_output_" + thisArgNameFull, Boolean.FALSE, null, null, "holder_conn", customClassLoader));
                            postFunctionCall.add("\t\t" + thisArgName + "[0] = (" + thisArgType + ")holder_output_" + thisArgNameFull + ";");
                        } else {
                            preObjectInit.addAll(this.getObjectConstructionCode(pltype, thisArgName, thisArgNameFull, Boolean.FALSE, null, null, null, customClassLoader));
                        }
                    }
                    if (typeIsHolder.booleanValue() && thisArgName.equals(thisArgNameFull) && !thisArgClass.getName().equals("[B")) {
                        preObjectInit.add("\t\t" + genericTypesOfArgs[j].getTypeName() + " holder_" + thisArgNameFull + " = new " + genericTypesOfArgs[j].getTypeName() + "(" + thisArgNameFull + "[0]);");
                        postFunctionCall.add("\t\t" + thisArgNameFull + "[0] = holder_" + thisArgNameFull + ".value;");
                        argsInfunctionCaller = argsInfunctionCaller + "holder_" + thisArgNameFull;
                        argsInSignature = argsInSignature + thisArgType + "[] " + thisArgName;
                    } else if (!typeIsHolder.booleanValue()) {
                        argsInSignature = argsInSignature + thisArgType + " " + thisArgName;
                        argsInfunctionCaller = argsInfunctionCaller + thisArgNameFull;
                    }
                    if (j == argsOfFunction.length - 1) continue;
                    argsInSignature = argsInSignature + ",";
                    argsInfunctionCaller = argsInfunctionCaller + ",";
                }
                functionSignature = functionSignature + "(" + argsInSignature + ") throws java.lang.Exception{";
                functionCaller = functionCaller + "(" + argsInfunctionCaller + ")";
                javaSrc.add(functionSignature);
                javaSrc.add("\t\tif(Utils.isSetCredentials) {");
                javaSrc.add("\t\t\tUtils.setDefaultAuthenticator();");
                javaSrc.add("\t\t}");
                javaSrc.add("\n\t\tUtils.setSSLContext();");
                for (int cnt = 0; cnt < preObjectInit.size(); ++cnt) {
                    javaSrc.add((String)preObjectInit.get(cnt));
                }
                if (connObjHolderReq.booleanValue()) {
                    javaSrc.add("\n\t\toracle.jdbc.driver.OracleDriver holder_driverDef = new oracle.jdbc.driver.OracleDriver();");
                    javaSrc.add("\t\tjava.sql.Connection holder_conn = holder_driverDef.defaultConnection();\n");
                }
                String retObjName = "retObj";
                if (retTypeClass.getName().equals("[B")) {
                    javaSrc.add("\t\tbyte[] " + retObjName + " = " + accessorObj + "." + functionCaller + ";");
                    for (int cnt = 0; cnt < postFunctionCall.size(); ++cnt) {
                        javaSrc.add((String)postFunctionCall.get(cnt));
                    }
                    javaSrc.add("\t\treturn retObj;");
                } else if (isComplexRetType.booleanValue()) {
                    XmlEnum enumAnnotation;
                    String connObjName = "conn";
                    javaSrc.add("\t\toracle.jdbc.driver.OracleDriver driverDef = new oracle.jdbc.driver.OracleDriver();");
                    javaSrc.add("\t\tjava.sql.Connection " + connObjName + " = driverDef.defaultConnection();\n");
                    String retTypeClassName = retTypeClass.getName().replaceAll("\\$", ".");
                    if (retTypeClass.getName().equalsIgnoreCase("java.util.List")) {
                        retTypeClassName = retTypeClassName + "<" + complexRetTypePlsqlType.innerGenericClass.getName() + ">";
                    }
                    if ((enumAnnotation = retTypeClass.getAnnotation(XmlEnum.class)) != null) {
                        String enumClass = retTypeClass.getSimpleName() + "Class";
                        javaSrc.add("\t\t" + enumClass + " " + retObjName + " = new " + enumClass + "();");
                        javaSrc.add("\t\tretObj.setValue(" + accessorObj + "." + functionCaller + ".name());");
                    } else {
                        javaSrc.add("\t\t" + retTypeClassName + " " + retObjName + " = " + accessorObj + "." + functionCaller + ";");
                    }
                    for (int cnt = 0; cnt < postFunctionCall.size(); ++cnt) {
                        javaSrc.add((String)postFunctionCall.get(cnt));
                    }
                    String newRetObjName = "";
                    newRetObjName = complexRetTypePlsqlType.isArrayType != false ? retObjName + "_Array" : retObjName + "_Struct";
                    ArrayList<String> retObjCre = this.getPlsqlReturnObjectCode(complexRetTypePlsqlType, retObjName, null, newRetObjName, Boolean.FALSE, null, null, connObjName, customClassLoader);
                    for (int t = 0; t < retObjCre.size(); ++t) {
                        javaSrc.add(retObjCre.get(t));
                    }
                    javaSrc.add("\t\treturn " + newRetObjName + ";");
                } else if (retTypeClass.getName().equalsIgnoreCase("void")) {
                    javaSrc.add("\t\t" + accessorObj + "." + functionCaller + ";");
                    for (int cnt = 0; cnt < postFunctionCall.size(); ++cnt) {
                        javaSrc.add((String)postFunctionCall.get(cnt));
                    }
                } else {
                    javaSrc.add("\t\t" + retTypeClass.getName().replaceAll("\\$", ".") + " " + retObjName + " = " + accessorObj + "." + functionCaller + ";");
                    for (int cnt = 0; cnt < postFunctionCall.size(); ++cnt) {
                        javaSrc.add((String)postFunctionCall.get(cnt));
                    }
                    javaSrc.add("\t\treturn retObj;");
                }
                javaSrc.add("\t}");
                if (!isComplexRetType.booleanValue() && retTypeClass == String.class) {
                    javaSrc.add("");
                    javaSrc.add("\tpublic static Clob " + methodUnderConsideration.getName() + "_Clob (" + argsInSignature + ") throws java.lang.Exception{");
                    javaSrc.add("\t\treturn ConversionUtils.toClob(" + methodUnderConsideration.getName() + "(" + argsInfunctionCaller + "));");
                    javaSrc.add("\t}");
                    continue;
                }
                if (isComplexRetType.booleanValue() || !retTypeClass.getName().equals("[B")) continue;
                javaSrc.add("");
                javaSrc.add("\tpublic static Blob " + methodUnderConsideration.getName() + "_Blob (" + argsInSignature + ") throws java.lang.Exception{");
                javaSrc.add("\t\treturn ConversionUtils.toBlob(" + methodUnderConsideration.getName() + "(" + argsInfunctionCaller.replace(".getBytes()", "") + "));");
                javaSrc.add("\t}");
            }
            javaSrc.add("");
            javaSrc.add("\tpublic static Object[] VerifyClass(oracle.sql.STRUCT arg, String cls){");
            javaSrc.add("\t\tObject[] ret = null; ");
            javaSrc.add("\t\ttry {");
            javaSrc.add("\t\t\tret = ((oracle.sql.STRUCT)arg).getAttributes();");
            javaSrc.add("\t\t} catch (java.lang.Exception e) { }");
            javaSrc.add("\t\treturn ret;");
            javaSrc.add("\t}");
            javaSrc.add("}");
            OjvmWCUUtils.writeToFile(fileName, javaSrc, this.inpPar);
            if (this.inpPar.keepSrc.booleanValue()) {
                OjvmWCUUtils.writeToFile(javaSrcKeepFileName, javaSrc, this.inpPar);
            }
        }
        catch (OjvmWCUException oe) {
            throw oe;
        }
        catch (Exception e) {
            throw new OjvmWCUException(2, "Creating Java Source", this.inpPar, e);
        }
        return Boolean.TRUE;
    }

    ArrayList<String> getVerifyFunctionCode() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("public Object[] Verify(oracle.sql.STRUCT stObj, Class presentClass) {");
        ret.add("Fields");
        return ret;
    }

    public String getUnUsedVariableName(String proposedVariableName) {
        if (this.usedVariableNames.containsKey(proposedVariableName)) {
            int count = this.usedVariableNames.get(proposedVariableName);
            this.usedVariableNames.put(proposedVariableName, count + 1);
            String vairableName = proposedVariableName + "_" + count;
            return vairableName;
        }
        this.usedVariableNames.put(proposedVariableName, 1);
        return proposedVariableName;
    }

    ArrayList<String> getPlsqlArrayReturnObjectCode(PlsqlType retPlsqlType, String retObjName, String newObjName, Boolean isInnerRetObjCreation, String connObjName, ClassLoader cl) throws OjvmWCUException {
        ArrayList<String> retStr = new ArrayList<String>();
        String arrayTypeClassName = retPlsqlType.innerGenericClass.getName();
        String retObjArrayName = this.getUnUsedVariableName("ORA_" + retObjName);
        String loopCountName = "LC_" + retObjName;
        retStr.add("\t\tObject[] " + retObjArrayName + " = new Object[" + retObjName + ".size()];");
        retStr.add("\n\t\tfor(int " + loopCountName + " = 0; " + loopCountName + " < " + retObjName + ".size(); " + loopCountName + "++){");
        Class typeClassOfArray = retPlsqlType.innerGenericClass;
        String mappedName = dataTypeMapJ2P.get(typeClassOfArray.getName());
        if (mappedName == null || mappedName.equalsIgnoreCase("")) {
            PlsqlType complexPlsqlTypeOfArray = null;
            String newNameForObjectCreated = retObjName + "_" + typeClassOfArray.getSimpleName();
            for (int j = 0; j < this.typeArrayList.size(); ++j) {
                if (!typeClassOfArray.equals(this.typeArrayList.get((int)j).classInfo)) continue;
                complexPlsqlTypeOfArray = this.typeArrayList.get(j);
                break;
            }
            String loopObjectName = this.getUnUsedVariableName("LO_" + newObjName);
            XmlEnum enumAnnotation = complexPlsqlTypeOfArray.classInfo.getAnnotation(XmlEnum.class);
            if (enumAnnotation != null) {
                retStr.add("\t\t\t" + complexPlsqlTypeOfArray.classInfo.getSimpleName() + "Class " + loopObjectName + " = new " + complexPlsqlTypeOfArray.classInfo.getSimpleName() + "Class();");
                retStr.add("\t\t\t" + loopObjectName + ".setValue(" + retObjName + ".get(" + loopCountName + ").name());");
            } else {
                retStr.add("\t\t\t" + complexPlsqlTypeOfArray.classInfo.getName() + " " + loopObjectName + " = " + retObjName + ".get(" + loopCountName + ");");
            }
            ArrayList<String> objCre = this.getPlsqlReturnObjectCode(complexPlsqlTypeOfArray, loopObjectName, null, newNameForObjectCreated, Boolean.FALSE, null, null, connObjName, cl);
            for (int k = 0; k < objCre.size(); ++k) {
                retStr.add(objCre.get(k));
            }
            retStr.add("\t\t\t" + retObjArrayName + "[" + loopCountName + "] = " + newNameForObjectCreated + ";");
        } else {
            retStr.add("\t\t\t" + retObjArrayName + "[" + loopCountName + "] = " + retObjName + ".get(" + loopCountName + ");");
        }
        retStr.add("\t\t}");
        retStr.add("\t\tjava.sql.Array " + newObjName + " = ((oracle.jdbc.OracleConnection)" + connObjName + ").createARRAY(\"" + retPlsqlType.newPlsqlTypeName.toUpperCase() + "\", " + retObjArrayName + ");");
        return retStr;
    }

    ArrayList<String> getPlsqlReturnObjectCode(PlsqlType returnPlsqlType, String returnObjectName, String retObjAccessorMethodName, String newObjectName, Boolean isInnerReturnObjectCreation, Field innerFieldObject, Class ownerClass, String connObjName, ClassLoader cl) throws OjvmWCUException {
        ArrayList<String> retStr = new ArrayList<String>();
        if (returnPlsqlType.isArrayType.booleanValue()) {
            String tempNewObjName = newObjectName;
            ArrayList<String> fromObj = null;
            if (isInnerReturnObjectCreation.booleanValue()) {
                String getterFunction = this.getAccessorSetterMethodForField(ownerClass, innerFieldObject, typeMethod.Accessor, cl);
                tempNewObjName = this.getUnUsedVariableName("TO_" + newObjectName);
                if (retObjAccessorMethodName != null && !retObjAccessorMethodName.isEmpty()) {
                    retStr.add("\t\tjava.util.List<" + returnPlsqlType.innerGenericClass.getName() + "> " + tempNewObjName + " = " + retObjAccessorMethodName + ";");
                } else {
                    retStr.add("\t\tjava.util.List<" + returnPlsqlType.innerGenericClass.getName() + "> " + tempNewObjName + " = " + returnObjectName + "." + getterFunction + "();");
                }
                returnObjectName = newObjectName;
                fromObj = this.getPlsqlArrayReturnObjectCode(returnPlsqlType, tempNewObjName, newObjectName, isInnerReturnObjectCreation, connObjName, cl);
            } else {
                fromObj = this.getPlsqlArrayReturnObjectCode(returnPlsqlType, returnObjectName, newObjectName, isInnerReturnObjectCreation, connObjName, cl);
            }
            for (int i = 0; i < fromObj.size(); ++i) {
                retStr.add(fromObj.get(i));
            }
        } else {
            long random = new Random(System.nanoTime()).nextLong();
            if (random < 0L) {
                random *= -1L;
            }
            String objectArrayNameCreated = "OR_" + returnObjectName + "_" + random;
            XmlEnum enumAnnotation = returnPlsqlType.classInfo.getAnnotation(XmlEnum.class);
            if (enumAnnotation != null) {
                retStr.add("\t\tObject[] " + objectArrayNameCreated + " = new Object[1];");
                if (retObjAccessorMethodName != null) {
                    retStr.add("\t\t" + objectArrayNameCreated + "[0] = (Object)" + retObjAccessorMethodName + ".name();");
                } else {
                    retStr.add("\t\t" + objectArrayNameCreated + "[0] = (Object) " + returnObjectName + ".getValue();");
                }
            } else {
                if (returnPlsqlType.newPlsqlTypeName.toUpperCase().equalsIgnoreCase("OBJ_XMLGREGORIANCALENDAR")) {
                    retStr.add("\t\tObject[] " + objectArrayNameCreated + " = new Object[1];");
                    retStr.add("\t\t" + objectArrayNameCreated + "[0]=(Object)" + retObjAccessorMethodName + ";");
                } else {
                    retStr.add("\t\tObject[] " + objectArrayNameCreated + " = new Object[" + returnPlsqlType.fields.size() + "];");
                }
                for (int i = 0; i < returnPlsqlType.fields.size(); ++i) {
                    Field currField = returnPlsqlType.fields.getField(i);
                    Class<?> currFieldClass = currField.getType();
                    String mappedTypeName = dataTypeMapJ2P.get(currFieldClass.getName());
                    String accessorMethodName = this.getAccessorSetterMethodForField(returnPlsqlType.classInfo, currField, typeMethod.Accessor, cl);
                    if (mappedTypeName == null || mappedTypeName.equalsIgnoreCase("")) {
                        PlsqlType currFieldPlsqlType = this.getPlsqlTypeFromTypeArrayOf(currField, cl);
                        String newRetObjName = this.getUnUsedVariableName(returnObjectName + "_" + currField.getName());
                        ArrayList<String> newObjCode = retObjAccessorMethodName != null && !retObjAccessorMethodName.isEmpty() ? this.getPlsqlReturnObjectCode(currFieldPlsqlType, returnObjectName, retObjAccessorMethodName + "." + accessorMethodName + "()", newRetObjName, Boolean.TRUE, currField, returnPlsqlType.classInfo, connObjName, cl) : this.getPlsqlReturnObjectCode(currFieldPlsqlType, returnObjectName, returnObjectName + "." + accessorMethodName + "()", newRetObjName, Boolean.TRUE, currField, returnPlsqlType.classInfo, connObjName, cl);
                        for (int j = 0; j < newObjCode.size(); ++j) {
                            retStr.add(newObjCode.get(j));
                        }
                        retStr.add("\t\t" + objectArrayNameCreated + "[" + i + "] = (Object)" + newRetObjName + ";");
                        continue;
                    }
                    if (retObjAccessorMethodName != null && !retObjAccessorMethodName.isEmpty()) {
                        retStr.add("\t\t" + objectArrayNameCreated + "[" + i + "] = (Object)" + retObjAccessorMethodName + "." + accessorMethodName + "();");
                        continue;
                    }
                    retStr.add("\t\t" + objectArrayNameCreated + "[" + i + "] = (Object)" + returnObjectName + "." + accessorMethodName + "();");
                }
            }
            String returnStructName = newObjectName;
            retStr.add("\t\tjava.sql.Struct " + returnStructName + " = " + connObjName + ".createStruct(\"" + returnPlsqlType.newPlsqlTypeName.toUpperCase() + "\", " + objectArrayNameCreated + ");");
        }
        return retStr;
    }

    ArrayList<String> getObjectConstructionCode(PlsqlType plsqlTypeToBeCreated, String plsqlObjectName, String objectNameToBeCreated, Boolean createArrayInsideObject, Field fieldOfClass, Class ownerClass, String ownerObjectName, ClassLoader customClassLoader) throws OjvmWCUException {
        ArrayList<String> retStr = new ArrayList<String>();
        if (plsqlTypeToBeCreated.isArrayType.booleanValue()) {
            ArrayList<String> arrCre = this.getArrayObjectConstructionCode(plsqlTypeToBeCreated, ownerClass, ownerObjectName, objectNameToBeCreated, plsqlObjectName, fieldOfClass, createArrayInsideObject, customClassLoader);
            for (int i = 0; i < arrCre.size(); ++i) {
                retStr.add(arrCre.get(i));
            }
        } else {
            String currentClassOfObjectToBeCreated = plsqlTypeToBeCreated.classInfo.getName().replaceAll("\\$", ".");
            String objectArrayName = this.getUnUsedVariableName("OAN_" + objectNameToBeCreated);
            XmlEnum enumAnnotation = plsqlTypeToBeCreated.classInfo.getAnnotation(XmlEnum.class);
            if (enumAnnotation != null) {
                retStr.add("\t\t" + currentClassOfObjectToBeCreated + " " + objectNameToBeCreated + ";");
                retStr.add("\t\tObject[] " + objectArrayName + " = VerifyClass((oracle.sql.STRUCT)" + plsqlObjectName + ", \"" + currentClassOfObjectToBeCreated + "Class\");");
                retStr.add("\t\t" + objectNameToBeCreated + " = " + plsqlTypeToBeCreated.classInfo.getSimpleName() + ".valueOf((java.lang.String)" + objectArrayName + "[0]);");
            } else {
                if (Modifier.isAbstract(plsqlTypeToBeCreated.classInfo.getModifiers())) {
                    retStr.add("\t\t//" + currentClassOfObjectToBeCreated + " " + objectNameToBeCreated + " = new " + currentClassOfObjectToBeCreated + "();");
                } else {
                    retStr.add("\t\t" + currentClassOfObjectToBeCreated + " " + objectNameToBeCreated + " = new " + currentClassOfObjectToBeCreated + "();");
                }
                retStr.add("\t\tObject[] " + objectArrayName + " = VerifyClass((oracle.sql.STRUCT)" + plsqlObjectName + ", \"" + currentClassOfObjectToBeCreated + "\");");
                myMap fieldsInClass = plsqlTypeToBeCreated.fields;
                for (int i = 0; i < fieldsInClass.size(); ++i) {
                    String ObjectArrayWithFieldIndex = objectArrayName + "[" + i + "]";
                    Field currentFieldOfObject = fieldsInClass.getField(i);
                    String currentFieldObjectName = currentFieldOfObject.getType().getName().replaceAll("\\$", ".");
                    if (currentFieldObjectName.equals("[B")) {
                        currentFieldObjectName = "byte[]";
                    }
                    String newObjectsName = this.getUnUsedVariableName(objectNameToBeCreated + "_" + currentFieldOfObject.getName());
                    String correspondingPlsqlTypeName = dataTypeMapJ2P.get(currentFieldOfObject.getType().getName());
                    if (correspondingPlsqlTypeName == null || correspondingPlsqlTypeName.equals("")) {
                        for (int j = 0; j < this.typeArrayList.size(); ++j) {
                            PlsqlType currentPlsqlType = this.typeArrayList.get(j);
                            if (!this.checkClassAndType(currentPlsqlType, currentFieldOfObject, customClassLoader).booleanValue()) continue;
                            ArrayList<String> objConstCode = this.getObjectConstructionCode(currentPlsqlType, ObjectArrayWithFieldIndex, newObjectsName, Boolean.TRUE, currentFieldOfObject, plsqlTypeToBeCreated.classInfo, objectNameToBeCreated, customClassLoader);
                            for (int k = 0; k < objConstCode.size(); ++k) {
                                retStr.add(objConstCode.get(k));
                            }
                            break;
                        }
                        if (currentFieldOfObject.getType().getName().equalsIgnoreCase("java.util.List")) continue;
                        String settorMethodName = this.getAccessorSetterMethodForField(plsqlTypeToBeCreated.classInfo, currentFieldOfObject, typeMethod.Settor, customClassLoader);
                        if (Modifier.isAbstract(currentFieldOfObject.getType().getModifiers())) {
                            if (currentFieldObjectName.equalsIgnoreCase("javax.xml.datatype.XMLGregorianCalendar")) {
                                retStr.add("\t\ttry{");
                                retStr.add("\t\t\tjava.lang.String str_" + newObjectsName + " = (java.lang.String)OAN_" + newObjectsName + "[0];");
                                retStr.add("\t\t\tjava.text.DateFormat for_" + newObjectsName + " = new java.text.SimpleDateFormat(\"yyyy-MM-dd hh:mm:ss\");");
                                retStr.add("\t\t\tjava.util.Date date_" + newObjectsName + " = for_" + newObjectsName + ".parse(str_" + newObjectsName + ");");
                                retStr.add("\t\t\tjava.util.GregorianCalendar cal_" + newObjectsName + "= new java.util.GregorianCalendar();");
                                retStr.add("\t\t\tcal_" + newObjectsName + ".setTime(date_" + newObjectsName + ");");
                                retStr.add("\t\t\t" + objectNameToBeCreated + "." + settorMethodName + "((javax.xml.datatype.XMLGregorianCalendar)javax.xml.datatype.DatatypeFactory.newInstance().newXMLGregorianCalendar(cal_" + newObjectsName + "));");
                                retStr.add("\t\t}");
                                retStr.add("\t\tcatch(Exception e){");
                                retStr.add("\t\t\t" + objectNameToBeCreated + "." + settorMethodName + "(null);");
                                retStr.add("\t\t}");
                                continue;
                            }
                            retStr.add("\t\t" + objectNameToBeCreated + "." + settorMethodName + "((" + currentFieldObjectName + ")OAN_" + newObjectsName + ");");
                            continue;
                        }
                        retStr.add("\t\t" + objectNameToBeCreated + "." + settorMethodName + "(" + newObjectsName + ");");
                        continue;
                    }
                    String settorMethodName = this.getAccessorSetterMethodForField(plsqlTypeToBeCreated.classInfo, currentFieldOfObject, typeMethod.Settor, customClassLoader);
                    retStr.add("\t\t" + objectNameToBeCreated + "." + settorMethodName + "((" + currentFieldObjectName + ")" + this.getActualObject(ObjectArrayWithFieldIndex, currentFieldOfObject.getType()) + ");");
                }
            }
        }
        return retStr;
    }

    ArrayList<String> getArrayObjectConstructionCode(PlsqlType arrayPlsqlType, Class ownerClass, String ownerObjectName, String newObjectName, String plsqlObjectName, Field fieldOfClassWhichIsArray, Boolean fromInsideAnotherObj, ClassLoader cl) throws OjvmWCUException {
        ArrayList<String> retStr = new ArrayList<String>();
        String arrayActualTypeName = arrayPlsqlType.innerGenericClass.getName();
        Class arrayConvertedTypeName = this.getConvertedPlsqlClassName(arrayPlsqlType.innerGenericClass);
        String arrayTypeNameOnly = arrayPlsqlType.innerGenericClass.getSimpleName();
        String tempArrayNameCreated = newObjectName + "_TA";
        String loopCountVarName = newObjectName + "_cnt";
        String newLoopObjName = newObjectName + "_" + arrayTypeNameOnly;
        if (fromInsideAnotherObj.booleanValue()) {
            String getterFunction = this.getAccessorSetterMethodForField(ownerClass, fieldOfClassWhichIsArray, typeMethod.Accessor, cl);
            retStr.add("\t\tjava.util.List<" + arrayActualTypeName + "> " + newObjectName + " = ((" + ownerClass.getName() + ")" + ownerObjectName + ")." + getterFunction + "();");
        } else {
            retStr.add("\t\tjava.util.List<" + arrayActualTypeName + "> " + newObjectName + " = new java.util.ArrayList<" + arrayActualTypeName + ">();");
        }
        String typeCorresponding = dataTypeMapJ2P.get(arrayActualTypeName);
        String loopSpecificVarName = newObjectName + "LTV";
        if (typeCorresponding == null || typeCorresponding.equalsIgnoreCase("")) {
            retStr.add("\t\tObject[] " + tempArrayNameCreated + " = (Object[])((oracle.sql.ARRAY)" + plsqlObjectName + ").getArray();");
            retStr.add("\n\t\tfor(int " + loopCountVarName + " = 0; " + loopCountVarName + " < " + tempArrayNameCreated + ".length; " + loopCountVarName + "++){");
            retStr.add("\t\tObject " + loopSpecificVarName + " = " + tempArrayNameCreated + "[" + loopCountVarName + "];");
            PlsqlType typeFromTypeListOfInnerArrayType = null;
            for (int i = 0; i < this.typeArrayList.size(); ++i) {
                if (!this.typeArrayList.get((int)i).classInfo.equals(arrayPlsqlType.innerGenericType.classInfo)) continue;
                typeFromTypeListOfInnerArrayType = this.typeArrayList.get(i);
                break;
            }
            ArrayList<String> objConstr = this.getObjectConstructionCode(typeFromTypeListOfInnerArrayType, loopSpecificVarName, newLoopObjName, Boolean.FALSE, null, typeFromTypeListOfInnerArrayType.classInfo, null, cl);
            for (int j = 0; j < objConstr.size(); ++j) {
                retStr.add(objConstr.get(j));
            }
            retStr.add("");
        } else {
            String actualVar;
            if (arrayActualTypeName.equals("java.lang.String")) {
                retStr.add("\t\t" + arrayConvertedTypeName.getName() + "[] " + tempArrayNameCreated + " = (" + arrayConvertedTypeName.getName() + "[])((oracle.sql.ARRAY)" + plsqlObjectName + ").getArray();");
                retStr.add("\n\t\tfor(int " + loopCountVarName + " = 0; " + loopCountVarName + " < " + tempArrayNameCreated + ".length; " + loopCountVarName + "++){");
                actualVar = tempArrayNameCreated + "[" + loopCountVarName + "]";
            } else {
                retStr.add("\n\t\tjava.math.BigDecimal[] javaArg_BD = (" + plsqlObjectName + "==null)?null:((java.math.BigDecimal[]) ((oracle.sql.ARRAY)" + plsqlObjectName + ").getArray());");
                retStr.add("\n\t\tfor(int " + loopCountVarName + " = 0; " + loopCountVarName + " < javaArg_BD.length; " + loopCountVarName + "++){");
                actualVar = "javaArg_BD[" + loopCountVarName + "]";
            }
            String convertedActualObject = this.getActualObject(actualVar, arrayPlsqlType.innerGenericClass);
            retStr.add("\t\t" + arrayActualTypeName + " " + loopSpecificVarName + " = " + convertedActualObject + ";");
            newLoopObjName = loopSpecificVarName;
        }
        retStr.add("\t\t\t" + newObjectName + ".add(" + newLoopObjName + ");");
        retStr.add("\t\t}");
        return retStr;
    }

    Boolean checkClassAndType(PlsqlType plsqlType, Field fieldUnderConsideration, ClassLoader cl) throws OjvmWCUException {
        Class<?> thisClass = fieldUnderConsideration.getType();
        if (thisClass.getName().equalsIgnoreCase("java.util.List")) {
            Class genericClass = this.getGenericClassFromGenericType(fieldUnderConsideration.getGenericType(), cl);
            if (plsqlType.isArrayType.booleanValue() && genericClass.equals(plsqlType.innerGenericClass)) {
                return Boolean.TRUE;
            }
        } else if (thisClass.equals(plsqlType.classInfo)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    PlsqlType getPlsqlTypeFromTypeArrayOf(Field currentField, ClassLoader cl) throws OjvmWCUException {
        Class<?> thisClass = currentField.getType();
        if (thisClass.getName().equalsIgnoreCase("java.util.List")) {
            Class genericClassIfList = this.getGenericClassFromGenericType(currentField.getGenericType(), cl);
            for (int i = 0; i < this.typeArrayList.size(); ++i) {
                if (!this.typeArrayList.get((int)i).isArrayType.booleanValue() || !this.typeArrayList.get((int)i).innerGenericClass.equals(genericClassIfList)) continue;
                return this.typeArrayList.get(i);
            }
        } else {
            for (int i = 0; i < this.typeArrayList.size(); ++i) {
                if (!this.typeArrayList.get((int)i).classInfo.equals(thisClass)) continue;
                return this.typeArrayList.get(i);
            }
        }
        return null;
    }

    String getAccessorSetterMethodForField(Class ownerCls, Field thisFld, typeMethod accessorOrSettor, ClassLoader cl) throws OjvmWCUException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
        }
        this.checkPackageAccess(ownerCls);
        Method[] methArr = ownerCls.getMethods();
        String currFieldName = thisFld.getName();
        if (currFieldName.startsWith("_")) {
            currFieldName = currFieldName.substring(1);
        }
        String type = "";
        type = accessorOrSettor == typeMethod.Accessor ? "get" : (accessorOrSettor == typeMethod.Settor && thisFld.getType().getName().equalsIgnoreCase("java.util.List") ? "get" : "set");
        for (int i = 0; i < methArr.length; ++i) {
            Method currMeth = methArr[i];
            if (currMeth.getName().equalsIgnoreCase(type + currFieldName)) {
                return currMeth.getName();
            }
            if (!currMeth.getName().equalsIgnoreCase("is" + currFieldName) || accessorOrSettor != typeMethod.Accessor) continue;
            return currMeth.getName();
        }
        throw new OjvmWCUException(15, "Problem finding Accessors", this.inpPar, null);
    }

    String getActualObject(String paramName, Class fld) {
        String nameStr = dataTypeMapJ2P.get(fld.getName());
        if (nameStr == null) {
            return paramName;
        }
        if (nameStr.equals("NUMBER") && (fld.equals(Boolean.class) || fld.equals(Boolean.TYPE))) {
            return "(((java.math.BigDecimal)" + paramName + ").intValue() != 0)";
        }
        if (nameStr.equals("NUMBER")) {
            if (fld.equals(Long.class)) {
                return "((java.math.BigDecimal)" + paramName + ").longValue()";
            }
            return "((java.math.BigDecimal)" + paramName + ").intValue()";
        }
        return paramName;
    }

    Class getConvertedPlsqlClassName(Class thisClass) throws OjvmWCUException {
        if (thisClass.getName().equalsIgnoreCase("java.lang.Integer")) {
            Class<?> retClass = null;
            try {
                retClass = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException cnfEx) {
                throw new OjvmWCUException(16, this.inpPar, cnfEx);
            }
            return retClass;
        }
        return thisClass;
    }

    public ArrayList<Method> getOperationFunctions(ClassLoader cl, File[] dir) throws OjvmWCUException {
        ArrayList<Method> retMethodList = new ArrayList<Method>();
        try {
            for (int fno = 0; fno < dir.length; ++fno) {
                if (!dir[fno].isFile() || !dir[fno].getName().endsWith(".class")) continue;
                String fileNameOnly = dir[fno].getName().substring(0, dir[fno].getName().indexOf(".class"));
                String loadingClassName = this.inpPar.packageName + "." + fileNameOnly;
                Class<?> loadedClass = cl.loadClass(loadingClassName);
                WebService webServiceClass = loadedClass.getAnnotation(WebService.class);
                if (webServiceClass == null) continue;
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
                }
                this.checkPackageAccess(loadedClass);
                Method[] classMethods = loadedClass.getMethods();
                for (int i = 0; i < classMethods.length; ++i) {
                    Method methodUnderConsideration = classMethods[i];
                    WebMethod webMethodMethod = methodUnderConsideration.getAnnotation(WebMethod.class);
                    if (webMethodMethod == null) continue;
                    retMethodList.add(methodUnderConsideration);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new OjvmWCUException(7, "Get operation", this.inpPar, cnfe);
        }
        return retMethodList;
    }

    public Boolean generateCleanupWrapper() throws OjvmWCUException {
        OjvmWCUUtils.writeToFile(this.inpPar.cleanUpFile, this.inpPar.webServiceCleanup, this.inpPar);
        return Boolean.TRUE;
    }

    public Boolean generateWrappersJAXRS() throws OjvmWCUException {
        JarOutputStream target;
        URLClassLoader generatedClassLoader;
        this.inpPar.OWCULogger.info("Generating Wrappers");
        ArrayList<File> fileList = new ArrayList<File>();
        String packagePath = this.inpPar.packageName;
        packagePath = packagePath.replaceAll("\\.", "/");
        File OutputDir = new File(this.inpPar.tmpDirectory);
        try {
            generatedClassLoader = URLClassLoader.newInstance(new URL[]{OutputDir.toURI().toURL()});
        }
        catch (MalformedURLException ex) {
            throw new OjvmWCUException(2, "Cannot create class loader for generated classes", this.inpPar, ex);
        }
        File directory = new File(this.inpPar.tmpDirectory + "/" + packagePath);
        if (!directory.exists()) {
            throw new OjvmWCUException(2, "Client Stub not Generated", this.inpPar, null);
        }
        File[] directoryFileList = directory.listFiles();
        String javaFileName = this.inpPar.tmpDirectory + "/" + packagePath + "/" + this.inpPar.nameOfWebService + ".java";
        String javaSrcKeepFileName = this.inpPar.outputDirectory + "/" + packagePath + "/" + this.inpPar.nameOfWebService + ".java";
        String javaClassName = this.inpPar.tmpDirectory + "/" + packagePath + "/" + this.inpPar.nameOfWebService + ".class";
        String jarFileName = this.inpPar.jarFileName;
        String plsqlWrapperName = this.inpPar.plsqlWrapperName;
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Parsing Generated Class Files");
        }
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Interpreting Webservice Operations");
        }
        ArrayList<Method> operations = this.getOperationFunctionsJAXRS(generatedClassLoader, directoryFileList);
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Generating Static Java Class");
        }
        this.generateJavaSrcJAXRS(operations, javaFileName, javaSrcKeepFileName, generatedClassLoader);
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Generating PLSQL Wrapper");
        }
        this.generatePLSQLWrappersJAXRS(operations, plsqlWrapperName, generatedClassLoader);
        this.compileJavaClass(javaFileName, this.getAdditionalClasspath());
        fileList.add(new File(javaClassName));
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Generating Jar files");
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        try {
            target = new JarOutputStream((OutputStream)new FileOutputStream(jarFileName), manifest);
        }
        catch (FileNotFoundException ex) {
            throw new OjvmWCUException(9, this.inpPar, ex);
        }
        catch (IOException ex) {
            throw new OjvmWCUException(9, this.inpPar, ex);
        }
        this.createCatalogProperties();
        this.createJar(target, new File(this.inpPar.tmpDirectory), this.inpPar.tmpDirectory, fileList);
        try {
            target.close();
        }
        catch (IOException ex) {
            throw new OjvmWCUException(9, this.inpPar, ex);
        }
        return Boolean.TRUE;
    }

    public Boolean createCatalogProperties() throws OjvmWCUException {
        ArrayList<String> catalogPropertiesFile = new ArrayList<String>();
        catalogPropertiesFile.add("catalogs=;");
        String outputCatalogPropertiesFile = this.inpPar.tmpDirectory + "/CatalogManager.properties";
        OjvmWCUUtils.writeToFile(outputCatalogPropertiesFile, catalogPropertiesFile, this.inpPar);
        return Boolean.TRUE;
    }

    private String[] getAdditionalClasspath() {
        ArrayList<String> addClassPath = new ArrayList<String>();
        String acp = this.inpPar.additionalClassPath;
        if (acp.endsWith(":")) {
            String tacp;
            acp = tacp = acp.substring(0, acp.length() - 1);
        }
        while (acp.contains(":")) {
            String tacp;
            int indSC = acp.indexOf(":");
            addClassPath.add(acp.substring(0, indSC));
            acp = tacp = acp.substring(indSC + 1);
        }
        addClassPath.add(acp);
        String[] array = new String[addClassPath.size() + 1];
        array[0] = this.inpPar.tmpDirectory + "/";
        for (int i = 1; i < array.length; ++i) {
            array[i] = (String)addClassPath.get(i - 1);
        }
        return array;
    }

    public Boolean generatePLSQLWrappersJAXRS(ArrayList<Method> methodList, String fileName, ClassLoader customClassLoader) {
        ArrayList<String> plsqlWrapperPackageDefn = new ArrayList<String>();
        ArrayList<String> plsqlWrapperPackageBody = new ArrayList<String>();
        this.inpPar.webServiceCleanup.add("DROP PACKAGE " + this.inpPar.nameOfWebService);
        this.inpPar.webServiceCleanup.add("/");
        plsqlWrapperPackageDefn.add("CREATE OR REPLACE PACKAGE " + this.inpPar.nameOfWebService + " AS ");
        plsqlWrapperPackageBody.add("CREATE OR REPLACE PACKAGE BODY " + this.inpPar.nameOfWebService + " IS");
        for (int i = 0; i < methodList.size(); ++i) {
            Method methodUnderConsideration = methodList.get(i);
            String methodUnderConsiderationJavaName = this.getResourceMethodeName(methodUnderConsideration);
            String plsqlFuncName = this.getNewPlsqlMethodName(methodUnderConsiderationJavaName);
            String callerString = "";
            String methodLineDefn = "";
            String methodLineBodyPart = "";
            methodLineBodyPart = methodLineBodyPart + this.inpPar.packageName + "." + this.inpPar.nameOfWebService + "." + methodUnderConsiderationJavaName + "()";
            callerString = callerString + this.inpPar.nameOfWebService + "." + plsqlFuncName + " ";
            methodLineDefn = methodLineDefn + "FUNCTION " + plsqlFuncName + " ";
            callerString = callerString + "() ";
            methodLineDefn = methodLineDefn + "RETURN ";
            methodLineBodyPart = methodLineBodyPart + " return ";
            methodLineDefn = methodLineDefn + "varchar2";
            methodLineBodyPart = methodLineBodyPart + "java.lang.String";
            this.inpPar.operationHelper.put(callerString, null);
            String methodLineBody = methodLineDefn;
            methodLineDefn = methodLineDefn + ";";
            methodLineBody = methodLineBody + "\n as language java name '";
            methodLineBody = methodLineBody + methodLineBodyPart + "';";
            plsqlWrapperPackageDefn.add(methodLineDefn);
            plsqlWrapperPackageBody.add(methodLineBody);
            String plsqlFuncNameSW = plsqlFuncName + "_Clob";
            String callerStringSW = "";
            String methodLineDefnSW = "";
            String methodLineBodyPartSW = "";
            methodLineBodyPartSW = methodLineBodyPartSW + this.inpPar.packageName + "." + this.inpPar.nameOfWebService + "." + methodUnderConsiderationJavaName + "_Clob()";
            callerStringSW = callerStringSW + this.inpPar.nameOfWebService + "." + plsqlFuncNameSW + " ";
            methodLineDefnSW = methodLineDefnSW + "FUNCTION " + plsqlFuncNameSW + " ";
            callerStringSW = callerStringSW + "() ";
            methodLineDefnSW = methodLineDefnSW + "RETURN ";
            methodLineBodyPartSW = methodLineBodyPartSW + " return ";
            methodLineDefnSW = methodLineDefnSW + "CLOB";
            methodLineBodyPartSW = methodLineBodyPartSW + "java.sql.Clob";
            this.inpPar.operationHelper.put(callerStringSW, null);
            String methodLineBodySW = methodLineDefnSW;
            methodLineDefnSW = methodLineDefnSW + ";";
            methodLineBodySW = methodLineBodySW + "\n as language java name '";
            methodLineBodySW = methodLineBodySW + methodLineBodyPartSW + "';";
            plsqlWrapperPackageDefn.add(methodLineDefnSW);
            plsqlWrapperPackageBody.add(methodLineBodySW);
        }
        plsqlWrapperPackageDefn.add("PROCEDURE " + this.credProcedureName + "(usr VARCHAR2, pwd VARCHAR2);");
        plsqlWrapperPackageDefn.add("PROCEDURE " + this.grabAndSaveCertificateProcedureName + "(host VARCHAR2, port VARCHAR2);");
        plsqlWrapperPackageBody.add("PROCEDURE " + this.credProcedureName + "(usr VARCHAR2, pwd VARCHAR2) AS LANGUAGE java NAME ");
        plsqlWrapperPackageBody.add("'oracle.ojvmwcu.security.Utils.setCredentials(java.lang.String, java.lang.String)';");
        plsqlWrapperPackageBody.add("PROCEDURE " + this.grabAndSaveCertificateProcedureName + "(host VARCHAR2, port VARCHAR2) AS LANGUAGE java NAME ");
        plsqlWrapperPackageBody.add("'oracle.ojvmwcu.security.Utils.grabAndSaveCertificate(java.lang.String, java.lang.String)';");
        this.inpPar.operationHelper.put(this.inpPar.nameOfWebService + "." + this.grabAndSaveCertificateProcedureName + "(VARCHAR2 host, VARCHAR2 port)", null);
        this.inpPar.operationHelper.put(this.inpPar.nameOfWebService + "." + this.credProcedureName + "(VARCHAR2 user, VARCHAR2 Password)", null);
        plsqlWrapperPackageDefn.add("END " + this.inpPar.nameOfWebService + ";");
        plsqlWrapperPackageBody.add("END " + this.inpPar.nameOfWebService + ";");
        plsqlWrapperPackageDefn.add("/");
        plsqlWrapperPackageBody.add("/");
        this.inpPar.webServiceWrapperContents.addAll(this.prePlsqlWrapper);
        this.inpPar.webServiceWrapperContents.addAll(plsqlWrapperPackageDefn);
        this.inpPar.webServiceWrapperContents.addAll(plsqlWrapperPackageBody);
        try {
            OjvmWCUUtils.writeToFile(fileName, this.inpPar.webServiceWrapperContents, this.inpPar);
        }
        catch (OjvmWCUException e) {
            e.printStackTrace();
        }
        return Boolean.TRUE;
    }

    private String getResourceMethodeName(Method methodUnderConsideration) {
        String methodName = "";
        String accessor = methodUnderConsideration.getDeclaringClass().getName();
        StringTokenizer token = new StringTokenizer(accessor, "$");
        String parameterType = methodUnderConsideration.getParameterTypes()[0].getSimpleName();
        if (token.hasMoreTokens()) {
            token.nextToken();
            while (token.hasMoreTokens()) {
                String resource = token.nextToken();
                methodName = methodName + resource;
                if (!token.hasMoreTokens()) continue;
                methodName = methodName + "_";
            }
        }
        methodName = methodName + "_" + methodUnderConsideration.getName() + "_" + parameterType.toLowerCase();
        return methodName;
    }

    public ArrayList<Method> getOperationFunctionsJAXRS(ClassLoader cl, File[] dir) {
        ArrayList<Method> operations = new ArrayList<Method>();
        ArrayList classList = new ArrayList();
        for (int fno = 0; fno < dir.length; ++fno) {
            if (!dir[fno].isFile() || !dir[fno].getName().endsWith(".class")) continue;
            String fileNameOnly = dir[fno].getName().substring(0, dir[fno].getName().indexOf(".class"));
            String rootClassName = this.inpPar.packageName + "." + fileNameOnly;
            Class<?> classunderConsideration = null;
            try {
                classunderConsideration = cl.loadClass(rootClassName);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            for (int j = 0; j < classunderConsideration.getMethods().length; ++j) {
                if (!classunderConsideration.getMethods()[j].getName().contains("getAs")) continue;
                operations.add(classunderConsideration.getMethods()[j]);
            }
        }
        return operations;
    }

    URLClassLoader getGeneratedClassLoader() throws OjvmWCUException {
        if (generatedClassLoader != null) {
            return generatedClassLoader;
        }
        File OutputDir = new File(this.inpPar.tmpDirectory);
        try {
            generatedClassLoader = URLClassLoader.newInstance(new URL[]{OutputDir.toURI().toURL()});
        }
        catch (MalformedURLException ex) {
            throw new OjvmWCUException(2, "Cannot create class loader for generated classes", this.inpPar, ex);
        }
        return generatedClassLoader;
    }

    File[] getGeneratedFiles(String packagePath) throws OjvmWCUException {
        File directory = new File(this.inpPar.tmpDirectory + "/" + packagePath);
        if (!directory.exists()) {
            throw new OjvmWCUException(2, "Client Stub not Generated", this.inpPar, null);
        }
        return directory.listFiles();
    }

    String getPackagePath() {
        String packagePath = this.inpPar.packageName;
        return packagePath.replaceAll("\\.", "/");
    }

    public Boolean generateWrappersJAXWS() throws OjvmWCUException {
        JarOutputStream target;
        this.inpPar.OWCULogger.info("Generating Wrappers");
        String packagePath = this.getPackagePath();
        ArrayList<File> fileList = new ArrayList<File>();
        URLClassLoader generatedClassLoader = this.getGeneratedClassLoader();
        File[] directoryFileList = this.getGeneratedFiles(packagePath);
        String javaFileName = this.inpPar.tmpDirectory + "/" + packagePath + "/" + this.inpPar.nameOfWebService + ".java";
        String javaSrcKeepFileName = this.inpPar.outputDirectory + "/" + packagePath + "/" + this.inpPar.nameOfWebService + ".java";
        String javaClassName = this.inpPar.tmpDirectory + "/" + packagePath + "/" + this.inpPar.nameOfWebService + ".class";
        String jarFileName = this.inpPar.jarFileName;
        String plsqlWrapperName = this.inpPar.plsqlWrapperName;
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Parsing Generated Class Files");
        }
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Generating Accessor Object");
        }
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Interpreting Webservice Operations");
        }
        ArrayList<Method> operations = this.getOperationFunctions(generatedClassLoader, directoryFileList);
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Generating PLSQL Wrapper");
        }
        this.generatePLSQLWrappers(operations, plsqlWrapperName, generatedClassLoader);
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Generating Static Java Class");
        }
        this.generateJavaSrc(operations, javaFileName, javaSrcKeepFileName, generatedClassLoader);
        this.generateEnumJavaSrc(operations, packagePath, generatedClassLoader);
        ArrayList<String> addClassPath = new ArrayList<String>();
        String acp = this.inpPar.additionalClassPath;
        if (acp.endsWith(";")) {
            String tacp;
            acp = tacp = acp.substring(0, acp.length() - 1);
        }
        while (acp.contains(";")) {
            String tacp;
            int indSC = acp.indexOf(";");
            addClassPath.add(acp.substring(0, indSC));
            acp = tacp = acp.substring(indSC + 1);
        }
        addClassPath.add(acp);
        String[] array = new String[addClassPath.size() + 1];
        array[0] = this.inpPar.tmpDirectory + "/";
        for (int i = 1; i < array.length; ++i) {
            array[i] = (String)addClassPath.get(i - 1);
        }
        this.compileJavaClass(javaFileName, array);
        fileList.add(new File(javaClassName));
        if (this.inpPar.OjvmWCUVerbose.booleanValue()) {
            this.inpPar.OWCULogger.info("Generating Jar files");
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        try {
            target = new JarOutputStream((OutputStream)new FileOutputStream(jarFileName), manifest);
        }
        catch (FileNotFoundException ex) {
            throw new OjvmWCUException(9, this.inpPar, ex);
        }
        catch (IOException ex) {
            throw new OjvmWCUException(9, this.inpPar, ex);
        }
        this.createCatalogProperties();
        this.createJar(target, new File(this.inpPar.tmpDirectory), this.inpPar.tmpDirectory, fileList);
        try {
            target.close();
        }
        catch (IOException ex) {
            throw new OjvmWCUException(9, this.inpPar, ex);
        }
        return Boolean.TRUE;
    }

    public Boolean createHelpFile() throws OjvmWCUException {
        String jarFile = new File(this.inpPar.jarFileName).getAbsolutePath();
        String gFile = new File(this.inpPar.grantFile).getAbsolutePath();
        String rFile = new File(this.inpPar.revokeFile).getAbsolutePath();
        String wFile = new File(this.inpPar.plsqlWrapperName).getAbsolutePath();
        String cleanwFile = wFile.replace("wrapper", "cleanup_wrapper");
        String helpStr = "";
        try {
            String curline;
            InputStream in = this.getClass().getResourceAsStream(this.readmeTemplate);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((curline = br.readLine()) != null) {
                helpStr = helpStr + curline + "\n";
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        helpStr = helpStr.replace("?jarFile?", jarFile);
        helpStr = helpStr.replace("?gFile?", gFile);
        helpStr = helpStr.replace("?rFile?", rFile);
        helpStr = helpStr.replace("?wFile?", wFile);
        helpStr = helpStr.replace("?cleanwFile?", cleanwFile);
        String newTypesString = "";
        if (this.inpPar.newTypesCreate.size() > 0) {
            newTypesString = "\n\tNew Types Created";
            for (int i = 0; i < this.inpPar.newTypesCreate.size(); ++i) {
                if (this.inpPar.newTypesCreate.get(i).equals("/")) continue;
                newTypesString = newTypesString + "\n\t" + this.inpPar.newTypesCreate.get(i);
            }
        }
        ArrayList AuthSSLHelp = new ArrayList();
        String Operations = "";
        for (Map.Entry<String, String> op : this.inpPar.operationHelper.entrySet()) {
            String operationName = op.getKey();
            if (operationName.contains(this.credProcedureName)) {
                helpStr = helpStr.replace("?credentials?", op.getKey().toString());
                continue;
            }
            if (operationName.contains(this.grabAndSaveCertificateProcedureName)) {
                helpStr = helpStr.replace("?truststore?", op.getKey().toString());
                continue;
            }
            if (op.getValue() != null) {
                Operations = Operations + "\n         \"" + op.getKey() + "\" returns \"" + op.getValue().toString().trim() + "\"";
                continue;
            }
            Operations = Operations + "\n         \"" + op.getKey() + "\"";
        }
        helpStr = helpStr.replace("?newTypes?", newTypesString);
        helpStr = helpStr.replace("?operations?", Operations);
        String outputHelpFile = this.inpPar.outputDirectory + "/README.txt";
        ArrayList<String> helpFile = new ArrayList<String>();
        helpFile.add(helpStr);
        OjvmWCUUtils.writeToFile(outputHelpFile, helpFile, this.inpPar);
        return Boolean.TRUE;
    }

    static {
        dataTypeMapJ2P.put("java.lang.String", "VARCHAR2");
        dataTypeMapJ2P.put("boolean", "NUMBER");
        dataTypeMapJ2P.put("char", "NUMBER");
        dataTypeMapJ2P.put("byte", "NUMBER");
        dataTypeMapJ2P.put("[B", "RAW");
        dataTypeMapJ2P.put("short", "NUMBER");
        dataTypeMapJ2P.put("int", "NUMBER");
        dataTypeMapJ2P.put("long", "NUMBER");
        dataTypeMapJ2P.put("float", "BINARY_FLOAT");
        dataTypeMapJ2P.put("double", "BINARY_DOUBLE");
        dataTypeMapJ2P.put("java.lang.Byte", "NUMBER");
        dataTypeMapJ2P.put("java.lang.Boolean", "NUMBER");
        dataTypeMapJ2P.put("java.lang.Short", "NUMBER");
        dataTypeMapJ2P.put("java.lang.Integer", "NUMBER");
        dataTypeMapJ2P.put("java.lang.Long", "NUMBER");
        dataTypeMapJ2P.put("java.lang.Float", "BINARY_FLOAT");
        dataTypeMapJ2P.put("java.lang.Double", "BINARY_DOUBLE");
        dataTypeMapJ2P.put("java.math.BigDecimal", "NUMBER");
        dataTypeMapJ2P.put("oracle.sql.CHAR", "VARCHAR2");
        dataTypeMapJ2P.put("oracle.sql.NUMBER", "NUMBER");
        dataTypeMapJ2P.put("oracle.sql.BINARY_FLOAT", "BINARY_FLOAT");
        dataTypeMapJ2P.put("oracle.sql.BINARY_DOUBLE", "BINARY_DOUBLE");
        dataTypeMapJ2P.put("oracle.sql.DATE", "DATE");
        dataTypeMapJ2P.put("oracle.sql.RAW", "RAW");
        dataTypeMapJ2P.put("oracle.sql.BLOB", "BLOB");
        dataTypeMapJ2P.put("oracle.sql.CLOB", "CLOB");
        dataTypeMapJ2P.put("oracle.sql.BFILE", "BFILE");
        dataTypeMapJ2P.put("oracle.sql.ROWID", "ROWID");
        dataTypeMapJ2P.put("oracle.sql.TIMESTAMP", "TIMESTAMP");
        dataTypeMapJ2P.put("oracle.sql.TIMESTAMPTZ", "TIMESTAMP WITH TIME ZONE");
        dataTypeMapJ2P.put("oracle.sql.TIMESTAMPLTZ", "TIMESTAMP WITH LOCAL TIME ZONE");
    }

    class myMap {
        protected ArrayList<String> name = new ArrayList();
        protected ArrayList<Field> field = new ArrayList();

        public void put(String na, Field fd) {
            this.name.add(na);
            this.field.add(fd);
        }

        public String getName(int no) {
            return this.name.get(no);
        }

        public Field getField(int no) {
            return this.field.get(no);
        }

        public int size() {
            return this.name.size();
        }
    }

    class PlsqlType {
        public String className = "";
        public ArrayList<String> typeDefnString = new ArrayList();
        public myMap fields = new myMap();
        public Class classInfo;
        public String newPlsqlTypeName = "";
        public Boolean isArrayType = Boolean.FALSE;
        public Boolean isComplexArrayType = Boolean.FALSE;
        public PlsqlType innerGenericType = null;
        public Class innerGenericClass = null;

        PlsqlType() {
        }
    }

    static enum typeMethod {
        Accessor,
        Settor;

    }
}

