Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: javavm_src_2/admin/fixTZa.sql
Rem    SQL_SHIPPED_FILE: javavm/admin/fixTZa.sql
Rem    SQL_PHASE: UTILITY
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA


/* This script is part of the fix for Oracle bug 36260537.  The problem
   in this bug is that java timezones in the java VM resident in the
   Oracle database are not up to date with respect to recent changes
   to when Daylight Savings Time applies in various time zones.
   The fix consists of installing a new versions of various data files in
   ORACLE_HOME/javavm/lib/zi, running two scripts, as SYS,
   of which this is the first, shutting down and restarting the instance
   after the first script is run and deferring running any java in the 
   instance until the second script is run.  The scripts will spool their 
   output to files named fixTZa.lst and fixTZb.lst in the 
   directory that is current when the sqlplus session used to run them is 
   started.  The output will contain messages delineated by lines of 
   # characters indicating any errors or the successful installation of 
   the fix.
*/

spool fixTZa
set define off
set serveroutput on
variable user_ varchar2(128)

alter session set java_jit_enabled=false;

begin 
 select username into :user_ from user_users;
 if :user_!='SYS' then
 dbms_output.put_line('########################################################');
 dbms_output.put_line('     This script must be run as SYS, not '||:user_);
 dbms_output.put_line('     Aborting with intentional ORA-00022');
 dbms_output.put_line('########################################################');
end if;end;
/

whenever sqlerror exit

declare foo exception; pragma exception_init(foo, -22);
begin if :user_!='SYS' then raise foo;end if;end;
/

whenever sqlerror continue

alter session set "_ORACLE_SCRIPT"=true;

begin
  if SYS_CONTEXT('USERENV','CON_ID') >= 2 then
    execute immediate 'create or replace java system';
  end if;
end;
/

create or replace java source named fixTZ as
import java.sql.*;
import java.io.*;
import oracle.jdbc.*;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import sun.util.calendar.*;
public class fixTZ {

  private static String AllPass;

  public static void test(String timezone, 
                          int year, 
                          int month, 
                          int mday, 
                          int hour, 
                          int min, 
                          int sec,
                          boolean shouldBeInDST)  {
    TimeZone tz = TimeZone.getTimeZone(timezone); 
    GregorianCalendar cal = new GregorianCalendar(tz);
    cal.set(year, month-1, mday, hour, min, sec); 
    if(tz.inDaylightTime(cal.getTime()) != shouldBeInDST)
      AllPass = AllPass + "FAILED for "+timezone+" "+hour+":"+min+":"+sec+" "+
                 month+"/"+mday+"/"+year+"\n";
  }
  
  public static void ntest(String timezone, long ms, int gmtOff, int dstOff)  {
    boolean lost = true;
    TimeZone tz = TimeZone.getTimeZone(timezone);
    if (tz.getID().equals(timezone)) {
      GregorianCalendar cal = new GregorianCalendar(tz);
      cal.setTimeInMillis(ms);
      if (cal.get(cal.ZONE_OFFSET) == gmtOff &&
          cal.get(cal.DST_OFFSET) == dstOff)
        lost = false;
    }
    if (lost)
      AllPass = AllPass + "FAILED for "+timezone+" "+ms+" "+gmtOff+" "+dstOff+"\n";
  }
  
  public static int testall() {
    String OK = "";
    AllPass = OK;
    System.out.println("Testing various timezone DST attributes");
    test("Australia/Perth", 2006, 12, 3, 1, 0, 10, false);
    test("Australia/Perth", 2006, 12, 3, 2, 0, 10, true);
    test("Australia/Perth", 2007, 3, 25, 1, 0, 10, true);
    test("Australia/Perth", 2007, 3, 25, 2, 0, 10, false);
    test("America/Vancouver", 2007, 3, 11, 10, 0, 0, true);
    test("America/Edmonton", 2007, 3, 11, 10, 0, 0, true);
    test("America/St_Johns", 2007, 3, 11, 10, 0, 0, true);
    test("America/New_York", 2007, 3, 11, 10, 0, 0, true);
    test("America/Los_Angeles", 2007, 3, 11, 10, 0, 0, true);
    test("Australia/Sydney", 2006, 3, 31, 10, 0, 0, true);
    test("Pacific/Auckland", 2007, 10, 1, 10, 0, 0, true);
    test("Pacific/Chatham", 2007, 10, 1, 10, 0, 0, true);
    test("Pacific/Auckland", 2008, 4, 1, 10, 0, 0, true);
    test("Pacific/Chatham", 2008, 4, 1, 10, 0, 0, true);
    test("Pacific/Auckland", 2008, 4, 10, 10, 0, 0, false);
    test("Pacific/Chatham", 2008, 4, 10, 10, 0, 0, false);
    test("America/Havana", 2008, 11, 1, 10, 0, 0, false);
    test("America/Cuiaba", 2008, 11, 1, 10, 0, 0, true);
    test("America/Cuiaba", 2009, 2, 18, 10, 0, 0, false);
    test("Africa/Cairo", 2008, 9, 1, 10, 0, 0, false);
    test("Asia/Damascus", 2008, 9, 15, 10, 0, 0, true);
    test("Asia/Jerusalem", 2008, 10, 1, 10, 0, 0, true);
    test("Asia/Tehran", 2008, 6, 22, 10, 0, 0, true);
    test("Australia/Lord_Howe", 2008, 10, 15, 2, 0, 10, true);

    ntest1();
    ntest2();
    ntest3();
    ntest4();
    ntest5();

    if (AllPass == OK)
      return 1;
    System.out.println(AllPass);
    return 0;
  }

  static void ntest1() {
    ntest("Africa/Abidjan", 1704067200000L, 0, 0);
    ntest("Africa/Accra", 1704067200000L, 0, 0);
    ntest("Africa/Addis_Ababa", 1704056400000L, 3*60*60*1000, 0);
    ntest("Africa/Algiers", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Asmara", 1704056400000L, 3*60*60*1000, 0);
    ntest("Africa/Asmera", 1704056400000L, 3*60*60*1000, 0);
    ntest("Africa/Bamako", 1704067200000L, 0, 0);
    ntest("Africa/Bangui", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Banjul", 1704067200000L, 0, 0);
    ntest("Africa/Bissau", 1704067200000L, 0, 0);
    ntest("Africa/Blantyre", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Brazzaville", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Bujumbura", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1714082399999L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1714082400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1730408399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1730408400000L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1745531999999L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1745532000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1761857999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1761858000000L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1776981599999L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1776981600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1793307599999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1793307600000L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1809035999999L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1809036000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1824757199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1824757200000L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1840485599999L, 2*60*60*1000, 0);
    ntest("Africa/Cairo", 1840485600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1856206799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Africa/Cairo", 1856206800000L, 2*60*60*1000, 0);
    ntest("Africa/Casablanca", 1704063600000L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1710035999999L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1710036000000L, 0, 0);
    ntest("Africa/Casablanca", 1713059999999L, 0, 0);
    ntest("Africa/Casablanca", 1713060000000L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1740275999999L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1740276000000L, 0, 0);
    ntest("Africa/Casablanca", 1743904799999L, 0, 0);
    ntest("Africa/Casablanca", 1743904800000L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1771120799999L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1771120800000L, 0, 0);
    ntest("Africa/Casablanca", 1774144799999L, 0, 0);
    ntest("Africa/Casablanca", 1774144800000L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1801965599999L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1801965600000L, 0, 0);
    ntest("Africa/Casablanca", 1804989599999L, 0, 0);
    ntest("Africa/Casablanca", 1804989600000L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1832205599999L, 0, 1*60*60*1000);
    ntest("Africa/Casablanca", 1832205600000L, 0, 0);
    ntest("Africa/Casablanca", 1835834399999L, 0, 0);
    ntest("Africa/Casablanca", 1835834400000L, 0, 1*60*60*1000);
    ntest("Africa/Ceuta", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1711846799999L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1729990800000L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1743296399999L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1761440400000L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1774745999999L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1792890000000L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1806195599999L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1824944400000L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1837645199999L, 1*60*60*1000, 0);
    ntest("Africa/Ceuta", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Africa/Ceuta", 1856394000000L, 1*60*60*1000, 0);
    ntest("Africa/Conakry", 1704067200000L, 0, 0);
    ntest("Africa/Dakar", 1704067200000L, 0, 0);
    ntest("Africa/Dar_es_Salaam", 1704056400000L, 3*60*60*1000, 0);
    ntest("Africa/Djibouti", 1704056400000L, 3*60*60*1000, 0);
    ntest("Africa/Douala", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/El_Aaiun", 1704063600000L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1710035999999L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1710036000000L, 0, 0);
    ntest("Africa/El_Aaiun", 1713059999999L, 0, 0);
    ntest("Africa/El_Aaiun", 1713060000000L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1740275999999L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1740276000000L, 0, 0);
    ntest("Africa/El_Aaiun", 1743904799999L, 0, 0);
    ntest("Africa/El_Aaiun", 1743904800000L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1771120799999L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1771120800000L, 0, 0);
    ntest("Africa/El_Aaiun", 1774144799999L, 0, 0);
    ntest("Africa/El_Aaiun", 1774144800000L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1801965599999L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1801965600000L, 0, 0);
    ntest("Africa/El_Aaiun", 1804989599999L, 0, 0);
    ntest("Africa/El_Aaiun", 1804989600000L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1832205599999L, 0, 1*60*60*1000);
    ntest("Africa/El_Aaiun", 1832205600000L, 0, 0);
    ntest("Africa/El_Aaiun", 1835834399999L, 0, 0);
    ntest("Africa/El_Aaiun", 1835834400000L, 0, 1*60*60*1000);
    ntest("Africa/Freetown", 1704067200000L, 0, 0);
    ntest("Africa/Gaborone", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Harare", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Johannesburg", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Juba", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Kampala", 1704056400000L, 3*60*60*1000, 0);
    ntest("Africa/Khartoum", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Kigali", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Kinshasa", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Lagos", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Libreville", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Lome", 1704067200000L, 0, 0);
    ntest("Africa/Luanda", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Lubumbashi", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Lusaka", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Malabo", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Maputo", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Maseru", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Mbabane", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Mogadishu", 1704056400000L, 3*60*60*1000, 0);
    ntest("Africa/Monrovia", 1704067200000L, 0, 0);
    ntest("Africa/Nairobi", 1704056400000L, 3*60*60*1000, 0);
    ntest("Africa/Ndjamena", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Niamey", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Nouakchott", 1704067200000L, 0, 0);
    ntest("Africa/Ouagadougou", 1704067200000L, 0, 0);
    ntest("Africa/Porto-Novo", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Sao_Tome", 1704067200000L, 0, 0);
    ntest("Africa/Timbuktu", 1704067200000L, 0, 0);
    ntest("Africa/Tripoli", 1704060000000L, 2*60*60*1000, 0);
    ntest("Africa/Tunis", 1704063600000L, 1*60*60*1000, 0);
    ntest("Africa/Windhoek", 1704060000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1704103200000L, -10*60*60*1000, 0);
    ntest("America/Adak", 1710071999999L, -10*60*60*1000, 0);
    ntest("America/Adak", 1710072000000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1730631599999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1730631600000L, -10*60*60*1000, 0);
    ntest("America/Adak", 1741521599999L, -10*60*60*1000, 0);
    ntest("America/Adak", 1741521600000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1762081199999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1762081200000L, -10*60*60*1000, 0);
    ntest("America/Adak", 1772971199999L, -10*60*60*1000, 0);
    ntest("America/Adak", 1772971200000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1793530799999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1793530800000L, -10*60*60*1000, 0);
    ntest("America/Adak", 1805025599999L, -10*60*60*1000, 0);
    ntest("America/Adak", 1805025600000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1825585199999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1825585200000L, -10*60*60*1000, 0);
    ntest("America/Adak", 1836475199999L, -10*60*60*1000, 0);
    ntest("America/Adak", 1836475200000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1857034799999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Adak", 1857034800000L, -10*60*60*1000, 0);
    ntest("America/Anchorage", 1704099600000L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1710068399999L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1710068400000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1730627999999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1730628000000L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1741517999999L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1741518000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1762077599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1762077600000L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1772967599999L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1772967600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1793527199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1793527200000L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1805021999999L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1805022000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1825581599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1825581600000L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1836471599999L, -9*60*60*1000, 0);
    ntest("America/Anchorage", 1836471600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1857031199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Anchorage", 1857031200000L, -9*60*60*1000, 0);
    ntest("America/Anguilla", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Antigua", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Araguaina", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Buenos_Aires", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Catamarca", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/ComodRivadavia", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Cordoba", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Jujuy", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/La_Rioja", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Mendoza", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Rio_Gallegos", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Salta", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/San_Juan", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/San_Luis", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Tucuman", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Argentina/Ushuaia", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Aruba", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1704078000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1711249199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1711249200000L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1728187199999L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1728187200000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1742698799999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1742698800000L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1759636799999L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1759636800000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1774148399999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1774148400000L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1791086399999L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1791086400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1806202799999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1806202800000L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1822535999999L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1822536000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1837652399999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Asuncion", 1837652400000L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1853985599999L, -4*60*60*1000, 0);
    ntest("America/Asuncion", 1853985600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Atikokan", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Atka", 1704103200000L, -10*60*60*1000, 0);
    ntest("America/Atka", 1710071999999L, -10*60*60*1000, 0);
    ntest("America/Atka", 1710072000000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1730631599999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1730631600000L, -10*60*60*1000, 0);
    ntest("America/Atka", 1741521599999L, -10*60*60*1000, 0);
    ntest("America/Atka", 1741521600000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1762081199999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1762081200000L, -10*60*60*1000, 0);
    ntest("America/Atka", 1772971199999L, -10*60*60*1000, 0);
    ntest("America/Atka", 1772971200000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1793530799999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1793530800000L, -10*60*60*1000, 0);
    ntest("America/Atka", 1805025599999L, -10*60*60*1000, 0);
    ntest("America/Atka", 1805025600000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1825585199999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1825585200000L, -10*60*60*1000, 0);
    ntest("America/Atka", 1836475199999L, -10*60*60*1000, 0);
    ntest("America/Atka", 1836475200000L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1857034799999L, -10*60*60*1000, 1*60*60*1000);
    ntest("America/Atka", 1857034800000L, -10*60*60*1000, 0);
    ntest("America/Bahia", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Bahia_Banderas", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Barbados", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Belem", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Belize", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Blanc-Sablon", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Boa_Vista", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Bogota", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Boise", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Boise", 1710061199999L, -7*60*60*1000, 0);
    ntest("America/Boise", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1730620800000L, -7*60*60*1000, 0);
    ntest("America/Boise", 1741510799999L, -7*60*60*1000, 0);
    ntest("America/Boise", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1762070400000L, -7*60*60*1000, 0);
    ntest("America/Boise", 1772960399999L, -7*60*60*1000, 0);
    ntest("America/Boise", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1793520000000L, -7*60*60*1000, 0);
    ntest("America/Boise", 1805014799999L, -7*60*60*1000, 0);
    ntest("America/Boise", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1825574400000L, -7*60*60*1000, 0);
    ntest("America/Boise", 1836464399999L, -7*60*60*1000, 0);
    ntest("America/Boise", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Boise", 1857024000000L, -7*60*60*1000, 0);
    ntest("America/Buenos_Aires", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1710061199999L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1730620800000L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1741510799999L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1762070400000L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1772960399999L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1793520000000L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1805014799999L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1825574400000L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1836464399999L, -7*60*60*1000, 0);
    ntest("America/Cambridge_Bay", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Cambridge_Bay", 1857024000000L, -7*60*60*1000, 0);
    ntest("America/Campo_Grande", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Cancun", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Caracas", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Catamarca", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Cayenne", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Cayman", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Chicago", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Chicago", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Chicago", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Chihuahua", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1710061199999L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1730620800000L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1741510799999L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1762070400000L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1772960399999L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1793520000000L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1805014799999L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1825574400000L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1836464399999L, -7*60*60*1000, 0);
    ntest("America/Ciudad_Juarez", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Ciudad_Juarez", 1857024000000L, -7*60*60*1000, 0);
    ntest("America/Coral_Harbour", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Cordoba", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Costa_Rica", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Creston", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Cuiaba", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Curacao", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Danmarkshavn", 1704067200000L, 0, 0);
    ntest("America/Dawson", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Dawson_Creek", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Denver", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Denver", 1710061199999L, -7*60*60*1000, 0);
    ntest("America/Denver", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1730620800000L, -7*60*60*1000, 0);
    ntest("America/Denver", 1741510799999L, -7*60*60*1000, 0);
    ntest("America/Denver", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1762070400000L, -7*60*60*1000, 0);
    ntest("America/Denver", 1772960399999L, -7*60*60*1000, 0);
    ntest("America/Denver", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1793520000000L, -7*60*60*1000, 0);
    ntest("America/Denver", 1805014799999L, -7*60*60*1000, 0);
    ntest("America/Denver", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1825574400000L, -7*60*60*1000, 0);
    ntest("America/Denver", 1836464399999L, -7*60*60*1000, 0);
    ntest("America/Denver", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Denver", 1857024000000L, -7*60*60*1000, 0);
    ntest("America/Detroit", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Detroit", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Detroit", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Dominica", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Edmonton", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1710061199999L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1730620800000L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1741510799999L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1762070400000L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1772960399999L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1793520000000L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1805014799999L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1825574400000L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1836464399999L, -7*60*60*1000, 0);
    ntest("America/Edmonton", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Edmonton", 1857024000000L, -7*60*60*1000, 0);
    ntest("America/Eirunepe", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/El_Salvador", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Ensenada", 1704096000000L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1710064799999L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1730624400000L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1741514399999L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1762074000000L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1772963999999L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1793523600000L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1805018399999L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1825578000000L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1836467999999L, -8*60*60*1000, 0);
    ntest("America/Ensenada", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Ensenada", 1857027600000L, -8*60*60*1000, 0);
    ntest("America/Fort_Nelson", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Fort_Wayne", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Fort_Wayne", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Fortaleza", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Glace_Bay", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1710050399999L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1710050400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1730609999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1730610000000L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1741499999999L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1741500000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1762059599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1762059600000L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1772949599999L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1772949600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1793509199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1793509200000L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1805003999999L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1805004000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1825563599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1825563600000L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1836453599999L, -4*60*60*1000, 0);
    ntest("America/Glace_Bay", 1836453600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1857013199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Glace_Bay", 1857013200000L, -4*60*60*1000, 0);
    ntest("America/Godthab", 1704074400000L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1711846799999L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1711846800000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1729990799999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1729990800000L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1743296399999L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1743296400000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1761440399999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1761440400000L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1774745999999L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1774746000000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1792889999999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1792890000000L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1806195599999L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1806195600000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1824944399999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1824944400000L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1837645199999L, -2*60*60*1000, 0);
    ntest("America/Godthab", 1837645200000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1856393999999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Godthab", 1856394000000L, -2*60*60*1000, 0);
    ntest("America/Goose_Bay", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1710050399999L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1710050400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1730609999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1730610000000L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1741499999999L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1741500000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1762059599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1762059600000L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1772949599999L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1772949600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1793509199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1793509200000L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1805003999999L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1805004000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1825563599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1825563600000L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1836453599999L, -4*60*60*1000, 0);
    ntest("America/Goose_Bay", 1836453600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1857013199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Goose_Bay", 1857013200000L, -4*60*60*1000, 0);
    ntest("America/Grand_Turk", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Grand_Turk", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Grand_Turk", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Grenada", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Guadeloupe", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Guatemala", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Guayaquil", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Guyana", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1710050399999L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1710050400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1730609999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1730610000000L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1741499999999L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1741500000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1762059599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1762059600000L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1772949599999L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1772949600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1793509199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1793509200000L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1805003999999L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1805004000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1825563599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1825563600000L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1836453599999L, -4*60*60*1000, 0);
    ntest("America/Halifax", 1836453600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1857013199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Halifax", 1857013200000L, -4*60*60*1000, 0);
    ntest("America/Havana", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Havana", 1710046799999L, -5*60*60*1000, 0);
    ntest("America/Havana", 1710046800000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1730609999999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1730610000000L, -5*60*60*1000, 0);
    ntest("America/Havana", 1741496399999L, -5*60*60*1000, 0);
    ntest("America/Havana", 1741496400000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1762059599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1762059600000L, -5*60*60*1000, 0);
    ntest("America/Havana", 1772945999999L, -5*60*60*1000, 0);
    ntest("America/Havana", 1772946000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1793509199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1793509200000L, -5*60*60*1000, 0);
    ntest("America/Havana", 1805000399999L, -5*60*60*1000, 0);
    ntest("America/Havana", 1805000400000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1825563599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1825563600000L, -5*60*60*1000, 0);
    ntest("America/Havana", 1836449999999L, -5*60*60*1000, 0);
    ntest("America/Havana", 1836450000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1857013199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Havana", 1857013200000L, -5*60*60*1000, 0);
    ntest("America/Hermosillo", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Indianapolis", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Indianapolis", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Knox", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Knox", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Marengo", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Marengo", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Petersburg", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Petersburg", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Indiana/Tell_City", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Tell_City", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vevay", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vevay", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Vincennes", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Vincennes", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Indiana/Winamac", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indiana/Winamac", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Indianapolis", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Indianapolis", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Inuvik", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1710061199999L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1730620800000L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1741510799999L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1762070400000L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1772960399999L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1793520000000L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1805014799999L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1825574400000L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1836464399999L, -7*60*60*1000, 0);
    ntest("America/Inuvik", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Inuvik", 1857024000000L, -7*60*60*1000, 0);
    ntest("America/Iqaluit", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Iqaluit", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Iqaluit", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Jamaica", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Jujuy", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Juneau", 1704099600000L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1710068399999L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1710068400000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1730627999999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1730628000000L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1741517999999L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1741518000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1762077599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1762077600000L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1772967599999L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1772967600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1793527199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1793527200000L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1805021999999L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1805022000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1825581599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1825581600000L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1836471599999L, -9*60*60*1000, 0);
    ntest("America/Juneau", 1836471600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1857031199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Juneau", 1857031200000L, -9*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Louisville", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Louisville", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Kentucky/Monticello", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Kentucky/Monticello", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Knox_IN", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Knox_IN", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Knox_IN", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Kralendijk", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/La_Paz", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Lima", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Los_Angeles", 1704096000000L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1710064799999L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1730624400000L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1741514399999L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1762074000000L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1772963999999L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1793523600000L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1805018399999L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1825578000000L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1836467999999L, -8*60*60*1000, 0);
    ntest("America/Los_Angeles", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Los_Angeles", 1857027600000L, -8*60*60*1000, 0);
    ntest("America/Louisville", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Louisville", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Louisville", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Lower_Princes", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Maceio", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Managua", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Manaus", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Marigot", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Martinique", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Matamoros", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Matamoros", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Matamoros", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Mazatlan", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Mendoza", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Menominee", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Menominee", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Menominee", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Merida", 1704088800000L, -6*60*60*1000, 0);
  }
  static void ntest2() {
    ntest("America/Metlakatla", 1704099600000L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1710068399999L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1710068400000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1730627999999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1730628000000L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1741517999999L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1741518000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1762077599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1762077600000L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1772967599999L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1772967600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1793527199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1793527200000L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1805021999999L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1805022000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1825581599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1825581600000L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1836471599999L, -9*60*60*1000, 0);
    ntest("America/Metlakatla", 1836471600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1857031199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Metlakatla", 1857031200000L, -9*60*60*1000, 0);
    ntest("America/Mexico_City", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Miquelon", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1710046799999L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1710046800000L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1730606399999L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1730606400000L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1741496399999L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1741496400000L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1762055999999L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1762056000000L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1772945999999L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1772946000000L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1793505599999L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1793505600000L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1805000399999L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1805000400000L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1825559999999L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1825560000000L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1836449999999L, -3*60*60*1000, 0);
    ntest("America/Miquelon", 1836450000000L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1857009599999L, -3*60*60*1000, 1*60*60*1000);
    ntest("America/Miquelon", 1857009600000L, -3*60*60*1000, 0);
    ntest("America/Moncton", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1710050399999L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1710050400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1730609999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1730610000000L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1741499999999L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1741500000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1762059599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1762059600000L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1772949599999L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1772949600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1793509199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1793509200000L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1805003999999L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1805004000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1825563599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1825563600000L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1836453599999L, -4*60*60*1000, 0);
    ntest("America/Moncton", 1836453600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1857013199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Moncton", 1857013200000L, -4*60*60*1000, 0);
    ntest("America/Monterrey", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Montevideo", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Montreal", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Montreal", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Montreal", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Montserrat", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Nassau", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Nassau", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nassau", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/New_York", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/New_York", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/New_York", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/New_York", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/New_York", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/New_York", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/New_York", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/New_York", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/New_York", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/New_York", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/New_York", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/New_York", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Nipigon", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Nipigon", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Nome", 1704099600000L, -9*60*60*1000, 0);
    ntest("America/Nome", 1710068399999L, -9*60*60*1000, 0);
    ntest("America/Nome", 1710068400000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1730627999999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1730628000000L, -9*60*60*1000, 0);
    ntest("America/Nome", 1741517999999L, -9*60*60*1000, 0);
    ntest("America/Nome", 1741518000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1762077599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1762077600000L, -9*60*60*1000, 0);
    ntest("America/Nome", 1772967599999L, -9*60*60*1000, 0);
    ntest("America/Nome", 1772967600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1793527199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1793527200000L, -9*60*60*1000, 0);
    ntest("America/Nome", 1805021999999L, -9*60*60*1000, 0);
    ntest("America/Nome", 1805022000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1825581599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1825581600000L, -9*60*60*1000, 0);
    ntest("America/Nome", 1836471599999L, -9*60*60*1000, 0);
    ntest("America/Nome", 1836471600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1857031199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Nome", 1857031200000L, -9*60*60*1000, 0);
    ntest("America/Noronha", 1704074400000L, -2*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Beulah", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Beulah", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/Center", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/Center", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/North_Dakota/New_Salem", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/North_Dakota/New_Salem", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Nuuk", 1704074400000L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1711846799999L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1711846800000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1729990799999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1729990800000L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1743296399999L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1743296400000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1761440399999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1761440400000L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1774745999999L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1774746000000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1792889999999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1792890000000L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1806195599999L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1806195600000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1824944399999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1824944400000L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1837645199999L, -2*60*60*1000, 0);
    ntest("America/Nuuk", 1837645200000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1856393999999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Nuuk", 1856394000000L, -2*60*60*1000, 0);
    ntest("America/Ojinaga", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Ojinaga", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Ojinaga", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Panama", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Pangnirtung", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Pangnirtung", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Paramaribo", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Phoenix", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Port-au-Prince", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Port-au-Prince", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Port_of_Spain", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Porto_Acre", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Porto_Velho", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Puerto_Rico", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Punta_Arenas", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Rainy_River", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Rainy_River", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rainy_River", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Rankin_Inlet", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Rankin_Inlet", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Recife", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Regina", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Resolute", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Resolute", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Rio_Branco", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Rosario", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1704096000000L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1710064799999L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1730624400000L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1741514399999L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1762074000000L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1772963999999L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1793523600000L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1805018399999L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1825578000000L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1836467999999L, -8*60*60*1000, 0);
    ntest("America/Santa_Isabel", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Santa_Isabel", 1857027600000L, -8*60*60*1000, 0);
    ntest("America/Santarem", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Santiago", 1704078000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1712458799999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1712458800000L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1725767999999L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1725768000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1743908399999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1743908400000L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1757217599999L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1757217600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1775357999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1775358000000L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1788667199999L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1788667200000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1806807599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1806807600000L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1820116799999L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1820116800000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1838257199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santiago", 1838257200000L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1851566399999L, -4*60*60*1000, 0);
    ntest("America/Santiago", 1851566400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Santo_Domingo", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Sao_Paulo", 1704078000000L, -3*60*60*1000, 0);
    ntest("America/Scoresbysund", 1704070800000L, -1*60*60*1000, 0);
    ntest("America/Scoresbysund", 1711846799999L, -1*60*60*1000, 0);
    ntest("America/Scoresbysund", 1711846800000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1729990799999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1729990800000L, -2*60*60*1000, 0);
    ntest("America/Scoresbysund", 1743296399999L, -2*60*60*1000, 0);
    ntest("America/Scoresbysund", 1743296400000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1761440399999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1761440400000L, -2*60*60*1000, 0);
    ntest("America/Scoresbysund", 1774745999999L, -2*60*60*1000, 0);
    ntest("America/Scoresbysund", 1774746000000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1792889999999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1792890000000L, -2*60*60*1000, 0);
    ntest("America/Scoresbysund", 1806195599999L, -2*60*60*1000, 0);
    ntest("America/Scoresbysund", 1806195600000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1824944399999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1824944400000L, -2*60*60*1000, 0);
    ntest("America/Scoresbysund", 1837645199999L, -2*60*60*1000, 0);
    ntest("America/Scoresbysund", 1837645200000L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1856393999999L, -2*60*60*1000, 1*60*60*1000);
    ntest("America/Scoresbysund", 1856394000000L, -2*60*60*1000, 0);
    ntest("America/Shiprock", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1710061199999L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1730620800000L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1741510799999L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1762070400000L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1772960399999L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1793520000000L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1805014799999L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1825574400000L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1836464399999L, -7*60*60*1000, 0);
    ntest("America/Shiprock", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Shiprock", 1857024000000L, -7*60*60*1000, 0);
    ntest("America/Sitka", 1704099600000L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1710068399999L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1710068400000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1730627999999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1730628000000L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1741517999999L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1741518000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1762077599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1762077600000L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1772967599999L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1772967600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1793527199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1793527200000L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1805021999999L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1805022000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1825581599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1825581600000L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1836471599999L, -9*60*60*1000, 0);
    ntest("America/Sitka", 1836471600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1857031199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Sitka", 1857031200000L, -9*60*60*1000, 0);
    ntest("America/St_Barthelemy", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/St_Johns", 1704079800000L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1710048599999L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1710048600000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1730608199999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1730608200000L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1741498199999L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1741498200000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1762057799999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1762057800000L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1772947799999L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1772947800000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1793507399999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1793507400000L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1805002199999L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1805002200000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1825561799999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1825561800000L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1836451799999L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Johns", 1836451800000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1857011399999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("America/St_Johns", 1857011400000L, -(3*60+30)*60*1000, 0);
    ntest("America/St_Kitts", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/St_Lucia", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/St_Thomas", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/St_Vincent", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Swift_Current", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Tegucigalpa", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Thule", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Thule", 1710050399999L, -4*60*60*1000, 0);
    ntest("America/Thule", 1710050400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1730609999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1730610000000L, -4*60*60*1000, 0);
    ntest("America/Thule", 1741499999999L, -4*60*60*1000, 0);
    ntest("America/Thule", 1741500000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1762059599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1762059600000L, -4*60*60*1000, 0);
    ntest("America/Thule", 1772949599999L, -4*60*60*1000, 0);
    ntest("America/Thule", 1772949600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1793509199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1793509200000L, -4*60*60*1000, 0);
    ntest("America/Thule", 1805003999999L, -4*60*60*1000, 0);
    ntest("America/Thule", 1805004000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1825563599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1825563600000L, -4*60*60*1000, 0);
    ntest("America/Thule", 1836453599999L, -4*60*60*1000, 0);
    ntest("America/Thule", 1836453600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1857013199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("America/Thule", 1857013200000L, -4*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Thunder_Bay", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Thunder_Bay", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Tijuana", 1704096000000L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1710064799999L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1730624400000L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1741514399999L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1762074000000L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1772963999999L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1793523600000L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1805018399999L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1825578000000L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1836467999999L, -8*60*60*1000, 0);
    ntest("America/Tijuana", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Tijuana", 1857027600000L, -8*60*60*1000, 0);
    ntest("America/Toronto", 1704085200000L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1710053999999L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1730613600000L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1741503599999L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1762063200000L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1772953199999L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1793512800000L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1805007599999L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1825567200000L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1836457199999L, -5*60*60*1000, 0);
    ntest("America/Toronto", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("America/Toronto", 1857016800000L, -5*60*60*1000, 0);
    ntest("America/Tortola", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Vancouver", 1704096000000L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1710064799999L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1730624400000L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1741514399999L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1762074000000L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1772963999999L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1793523600000L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1805018399999L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1825578000000L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1836467999999L, -8*60*60*1000, 0);
    ntest("America/Vancouver", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("America/Vancouver", 1857027600000L, -8*60*60*1000, 0);
    ntest("America/Virgin", 1704081600000L, -4*60*60*1000, 0);
    ntest("America/Whitehorse", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Winnipeg", 1704088800000L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1710057599999L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1730617200000L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1741507199999L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1762066800000L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1772956799999L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1793516400000L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1805011199999L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1825570800000L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1836460799999L, -6*60*60*1000, 0);
    ntest("America/Winnipeg", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("America/Winnipeg", 1857020400000L, -6*60*60*1000, 0);
    ntest("America/Yakutat", 1704099600000L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1710068399999L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1710068400000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1730627999999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1730628000000L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1741517999999L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1741518000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1762077599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1762077600000L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1772967599999L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1772967600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1793527199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1793527200000L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1805021999999L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1805022000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1825581599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1825581600000L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1836471599999L, -9*60*60*1000, 0);
    ntest("America/Yakutat", 1836471600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1857031199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("America/Yakutat", 1857031200000L, -9*60*60*1000, 0);
    ntest("America/Yellowknife", 1704092400000L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1710061199999L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1730620800000L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1741510799999L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1762070400000L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1772960399999L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1793520000000L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1805014799999L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1825574400000L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1836464399999L, -7*60*60*1000, 0);
    ntest("America/Yellowknife", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("America/Yellowknife", 1857024000000L, -7*60*60*1000, 0);
    ntest("Antarctica/Casey", 1704038400000L, 8*60*60*1000, 0);
    ntest("Antarctica/Davis", 1704042000000L, 7*60*60*1000, 0);
    ntest("Antarctica/DumontDUrville", 1704031200000L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1712419200000L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1728143999999L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1743868800000L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1759593599999L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1775318400000L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1791043199999L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1806768000000L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1822492799999L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Macquarie", 1838217600000L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1853942399999L, 10*60*60*1000, 0);
    ntest("Antarctica/Macquarie", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Mawson", 1704049200000L, 5*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1704020400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1712411999999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1712412000000L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1727531999999L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1727532000000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1743861599999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1743861600000L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1758981599999L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1758981600000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1775311199999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1775311200000L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1790431199999L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1790431200000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1806760799999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1806760800000L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1821880799999L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1821880800000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1838210399999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/McMurdo", 1838210400000L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1853330399999L, 12*60*60*1000, 0);
    ntest("Antarctica/McMurdo", 1853330400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Palmer", 1704078000000L, -3*60*60*1000, 0);
    ntest("Antarctica/Rothera", 1704078000000L, -3*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1704020400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1712411999999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1712412000000L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1727531999999L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1727532000000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1743861599999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1743861600000L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1758981599999L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1758981600000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1775311199999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1775311200000L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1790431199999L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1790431200000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1806760799999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1806760800000L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1821880799999L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1821880800000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1838210399999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/South_Pole", 1838210400000L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1853330399999L, 12*60*60*1000, 0);
    ntest("Antarctica/South_Pole", 1853330400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Antarctica/Syowa", 1704056400000L, 3*60*60*1000, 0);
    ntest("Antarctica/Troll", 1704067200000L, 0, 0);
    ntest("Antarctica/Troll", 1711846799999L, 0, 0);
    ntest("Antarctica/Troll", 1711846800000L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1729990799999L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1729990800000L, 0, 0);
    ntest("Antarctica/Troll", 1743296399999L, 0, 0);
    ntest("Antarctica/Troll", 1743296400000L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1761440399999L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1761440400000L, 0, 0);
    ntest("Antarctica/Troll", 1774745999999L, 0, 0);
    ntest("Antarctica/Troll", 1774746000000L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1792889999999L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1792890000000L, 0, 0);
    ntest("Antarctica/Troll", 1806195599999L, 0, 0);
    ntest("Antarctica/Troll", 1806195600000L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1824944399999L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1824944400000L, 0, 0);
    ntest("Antarctica/Troll", 1837645199999L, 0, 0);
    ntest("Antarctica/Troll", 1837645200000L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1856393999999L, 0, 2*60*60*1000);
    ntest("Antarctica/Troll", 1856394000000L, 0, 0);
    ntest("Antarctica/Vostok", 1704049200000L, 5*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1704063600000L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1711846799999L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1729990800000L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1743296399999L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1761440400000L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1774745999999L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1792890000000L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1806195599999L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1824944400000L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1837645199999L, 1*60*60*1000, 0);
    ntest("Arctic/Longyearbyen", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Arctic/Longyearbyen", 1856394000000L, 1*60*60*1000, 0);
    ntest("Asia/Aden", 1704056400000L, 3*60*60*1000, 0);
    ntest("Asia/Almaty", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Almaty", 1709229599999L, 6*60*60*1000, 0);
    ntest("Asia/Almaty", 1709229600000L, 5*60*60*1000, 0);
    ntest("Asia/Amman", 1704056400000L, 3*60*60*1000, 0);
    ntest("Asia/Anadyr", 1704024000000L, 12*60*60*1000, 0);
    ntest("Asia/Aqtau", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Aqtobe", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Ashgabat", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Ashkhabad", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Atyrau", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Baghdad", 1704056400000L, 3*60*60*1000, 0);
    ntest("Asia/Bahrain", 1704056400000L, 3*60*60*1000, 0);
    ntest("Asia/Baku", 1704052800000L, 4*60*60*1000, 0);
    ntest("Asia/Bangkok", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Barnaul", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Beirut", 1704060000000L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1711835999999L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1711836000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1729976399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1729976400000L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1743285599999L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1743285600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1761425999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1761426000000L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1774735199999L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1774735200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1792875599999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1792875600000L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1806184799999L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1806184800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1824929999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1824930000000L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1837634399999L, 2*60*60*1000, 0);
    ntest("Asia/Beirut", 1837634400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1856379599999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Beirut", 1856379600000L, 2*60*60*1000, 0);
    ntest("Asia/Bishkek", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Brunei", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Calcutta", 1704047400000L, (5*60+30)*60*1000, 0);
    ntest("Asia/Chita", 1704034800000L, 9*60*60*1000, 0);
    ntest("Asia/Choibalsan", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Chongqing", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Chungking", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Colombo", 1704047400000L, (5*60+30)*60*1000, 0);
    ntest("Asia/Dacca", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Damascus", 1704056400000L, 3*60*60*1000, 0);
    ntest("Asia/Dhaka", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Dili", 1704034800000L, 9*60*60*1000, 0);
    ntest("Asia/Dubai", 1704052800000L, 4*60*60*1000, 0);
    ntest("Asia/Dushanbe", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Famagusta", 1704060000000L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1711846799999L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1729990800000L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1743296399999L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1761440400000L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1774745999999L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1792890000000L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1806195599999L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1824944400000L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1837645199999L, 2*60*60*1000, 0);
    ntest("Asia/Famagusta", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Famagusta", 1856394000000L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1704060000000L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1713571199999L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1713571200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1729897199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1729897200000L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1744415999999L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1744416000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1761346799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1761346800000L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1774655999999L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1774656000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1792796399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1792796400000L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1806105599999L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1806105600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1824850799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1824850800000L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1837555199999L, 2*60*60*1000, 0);
    ntest("Asia/Gaza", 1837555200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1856300399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Gaza", 1856300400000L, 2*60*60*1000, 0);
    ntest("Asia/Harbin", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Hebron", 1704060000000L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1713571199999L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1713571200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1729897199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1729897200000L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1744415999999L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1744416000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1761346799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1761346800000L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1774655999999L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1774656000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1792796399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1792796400000L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1806105599999L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1806105600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1824850799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1824850800000L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1837555199999L, 2*60*60*1000, 0);
    ntest("Asia/Hebron", 1837555200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1856300399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Hebron", 1856300400000L, 2*60*60*1000, 0);
    ntest("Asia/Ho_Chi_Minh", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Hong_Kong", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Hovd", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Irkutsk", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Istanbul", 1704056400000L, 3*60*60*1000, 0);
    ntest("Asia/Jakarta", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Jayapura", 1704034800000L, 9*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1704060000000L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1711670399999L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1711670400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1729983599999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1729983600000L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1743119999999L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1743120000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1761433199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1761433200000L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1774569599999L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1774569600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1792882799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1792882800000L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1806019199999L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1806019200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1824937199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1824937200000L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1837468799999L, 2*60*60*1000, 0);
    ntest("Asia/Jerusalem", 1837468800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1856386799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Jerusalem", 1856386800000L, 2*60*60*1000, 0);
    ntest("Asia/Kabul", 1704051000000L, (4*60+30)*60*1000, 0);
    ntest("Asia/Kamchatka", 1704024000000L, 12*60*60*1000, 0);
    ntest("Asia/Karachi", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Kashgar", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Kathmandu", 1704046500000L, (5*60+45)*60*1000, 0);
    ntest("Asia/Katmandu", 1704046500000L, (5*60+45)*60*1000, 0);
    ntest("Asia/Khandyga", 1704034800000L, 9*60*60*1000, 0);
    ntest("Asia/Kolkata", 1704047400000L, (5*60+30)*60*1000, 0);
    ntest("Asia/Krasnoyarsk", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Kuala_Lumpur", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Kuching", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Kuwait", 1704056400000L, 3*60*60*1000, 0);
    ntest("Asia/Macao", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Macau", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Magadan", 1704027600000L, 11*60*60*1000, 0);
    ntest("Asia/Makassar", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Manila", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Muscat", 1704052800000L, 4*60*60*1000, 0);
    ntest("Asia/Nicosia", 1704060000000L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1711846799999L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1729990800000L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1743296399999L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1761440400000L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1774745999999L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1792890000000L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1806195599999L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1824944400000L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1837645199999L, 2*60*60*1000, 0);
    ntest("Asia/Nicosia", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Nicosia", 1856394000000L, 2*60*60*1000, 0);
    ntest("Asia/Novokuznetsk", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Novosibirsk", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Omsk", 1704045600000L, 6*60*60*1000, 0);
  }
  static void ntest3() {
    ntest("Asia/Oral", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Phnom_Penh", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Pontianak", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Pyongyang", 1704034800000L, 9*60*60*1000, 0);
    ntest("Asia/Qatar", 1704056400000L, 3*60*60*1000, 0);
    ntest("Asia/Qostanay", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Qostanay", 1709229599999L, 6*60*60*1000, 0);
    ntest("Asia/Qostanay", 1709229600000L, 5*60*60*1000, 0);
    ntest("Asia/Qyzylorda", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Rangoon", 1704043800000L, (6*60+30)*60*1000, 0);
    ntest("Asia/Saigon", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Sakhalin", 1704027600000L, 11*60*60*1000, 0);
    ntest("Asia/Samarkand", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Seoul", 1704034800000L, 9*60*60*1000, 0);
    ntest("Asia/Shanghai", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Singapore", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Srednekolymsk", 1704027600000L, 11*60*60*1000, 0);
    ntest("Asia/Taipei", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Tashkent", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Tbilisi", 1704052800000L, 4*60*60*1000, 0);
    ntest("Asia/Tehran", 1704054600000L, (3*60+30)*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1704060000000L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1711670399999L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1711670400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1729983599999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1729983600000L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1743119999999L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1743120000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1761433199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1761433200000L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1774569599999L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1774569600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1792882799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1792882800000L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1806019199999L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1806019200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1824937199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1824937200000L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1837468799999L, 2*60*60*1000, 0);
    ntest("Asia/Tel_Aviv", 1837468800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1856386799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Asia/Tel_Aviv", 1856386800000L, 2*60*60*1000, 0);
    ntest("Asia/Thimbu", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Thimphu", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Tokyo", 1704034800000L, 9*60*60*1000, 0);
    ntest("Asia/Tomsk", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Ujung_Pandang", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Ulaanbaatar", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Ulan_Bator", 1704038400000L, 8*60*60*1000, 0);
    ntest("Asia/Urumqi", 1704045600000L, 6*60*60*1000, 0);
    ntest("Asia/Ust-Nera", 1704031200000L, 10*60*60*1000, 0);
    ntest("Asia/Vientiane", 1704042000000L, 7*60*60*1000, 0);
    ntest("Asia/Vladivostok", 1704031200000L, 10*60*60*1000, 0);
    ntest("Asia/Yakutsk", 1704034800000L, 9*60*60*1000, 0);
    ntest("Asia/Yangon", 1704043800000L, (6*60+30)*60*1000, 0);
    ntest("Asia/Yekaterinburg", 1704049200000L, 5*60*60*1000, 0);
    ntest("Asia/Yerevan", 1704052800000L, 4*60*60*1000, 0);
    ntest("Atlantic/Azores", 1704070800000L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1711846799999L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1711846800000L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1729990799999L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1729990800000L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1743296399999L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1743296400000L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1761440399999L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1761440400000L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1774745999999L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1774746000000L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1792889999999L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1792890000000L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1806195599999L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1806195600000L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1824944399999L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1824944400000L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1837645199999L, -1*60*60*1000, 0);
    ntest("Atlantic/Azores", 1837645200000L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1856393999999L, -1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Azores", 1856394000000L, -1*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1704081600000L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1710050399999L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1710050400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1730609999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1730610000000L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1741499999999L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1741500000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1762059599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1762059600000L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1772949599999L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1772949600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1793509199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1793509200000L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1805003999999L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1805004000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1825563599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1825563600000L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1836453599999L, -4*60*60*1000, 0);
    ntest("Atlantic/Bermuda", 1836453600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1857013199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Bermuda", 1857013200000L, -4*60*60*1000, 0);
    ntest("Atlantic/Canary", 1704067200000L, 0, 0);
    ntest("Atlantic/Canary", 1711846799999L, 0, 0);
    ntest("Atlantic/Canary", 1711846800000L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1729990799999L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1729990800000L, 0, 0);
    ntest("Atlantic/Canary", 1743296399999L, 0, 0);
    ntest("Atlantic/Canary", 1743296400000L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1761440399999L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1761440400000L, 0, 0);
    ntest("Atlantic/Canary", 1774745999999L, 0, 0);
    ntest("Atlantic/Canary", 1774746000000L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1792889999999L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1792890000000L, 0, 0);
    ntest("Atlantic/Canary", 1806195599999L, 0, 0);
    ntest("Atlantic/Canary", 1806195600000L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1824944399999L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1824944400000L, 0, 0);
    ntest("Atlantic/Canary", 1837645199999L, 0, 0);
    ntest("Atlantic/Canary", 1837645200000L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1856393999999L, 0, 1*60*60*1000);
    ntest("Atlantic/Canary", 1856394000000L, 0, 0);
    ntest("Atlantic/Cape_Verde", 1704070800000L, -1*60*60*1000, 0);
    ntest("Atlantic/Faeroe", 1704067200000L, 0, 0);
    ntest("Atlantic/Faeroe", 1711846799999L, 0, 0);
    ntest("Atlantic/Faeroe", 1711846800000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1729990799999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1729990800000L, 0, 0);
    ntest("Atlantic/Faeroe", 1743296399999L, 0, 0);
    ntest("Atlantic/Faeroe", 1743296400000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1761440399999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1761440400000L, 0, 0);
    ntest("Atlantic/Faeroe", 1774745999999L, 0, 0);
    ntest("Atlantic/Faeroe", 1774746000000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1792889999999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1792890000000L, 0, 0);
    ntest("Atlantic/Faeroe", 1806195599999L, 0, 0);
    ntest("Atlantic/Faeroe", 1806195600000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1824944399999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1824944400000L, 0, 0);
    ntest("Atlantic/Faeroe", 1837645199999L, 0, 0);
    ntest("Atlantic/Faeroe", 1837645200000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1856393999999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faeroe", 1856394000000L, 0, 0);
    ntest("Atlantic/Faroe", 1704067200000L, 0, 0);
    ntest("Atlantic/Faroe", 1711846799999L, 0, 0);
    ntest("Atlantic/Faroe", 1711846800000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1729990799999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1729990800000L, 0, 0);
    ntest("Atlantic/Faroe", 1743296399999L, 0, 0);
    ntest("Atlantic/Faroe", 1743296400000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1761440399999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1761440400000L, 0, 0);
    ntest("Atlantic/Faroe", 1774745999999L, 0, 0);
    ntest("Atlantic/Faroe", 1774746000000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1792889999999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1792890000000L, 0, 0);
    ntest("Atlantic/Faroe", 1806195599999L, 0, 0);
    ntest("Atlantic/Faroe", 1806195600000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1824944399999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1824944400000L, 0, 0);
    ntest("Atlantic/Faroe", 1837645199999L, 0, 0);
    ntest("Atlantic/Faroe", 1837645200000L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1856393999999L, 0, 1*60*60*1000);
    ntest("Atlantic/Faroe", 1856394000000L, 0, 0);
    ntest("Atlantic/Jan_Mayen", 1704063600000L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1711846799999L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1729990800000L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1743296399999L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1761440400000L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1774745999999L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1792890000000L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1806195599999L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1824944400000L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1837645199999L, 1*60*60*1000, 0);
    ntest("Atlantic/Jan_Mayen", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Atlantic/Jan_Mayen", 1856394000000L, 1*60*60*1000, 0);
    ntest("Atlantic/Madeira", 1704067200000L, 0, 0);
    ntest("Atlantic/Madeira", 1711846799999L, 0, 0);
    ntest("Atlantic/Madeira", 1711846800000L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1729990799999L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1729990800000L, 0, 0);
    ntest("Atlantic/Madeira", 1743296399999L, 0, 0);
    ntest("Atlantic/Madeira", 1743296400000L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1761440399999L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1761440400000L, 0, 0);
    ntest("Atlantic/Madeira", 1774745999999L, 0, 0);
    ntest("Atlantic/Madeira", 1774746000000L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1792889999999L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1792890000000L, 0, 0);
    ntest("Atlantic/Madeira", 1806195599999L, 0, 0);
    ntest("Atlantic/Madeira", 1806195600000L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1824944399999L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1824944400000L, 0, 0);
    ntest("Atlantic/Madeira", 1837645199999L, 0, 0);
    ntest("Atlantic/Madeira", 1837645200000L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1856393999999L, 0, 1*60*60*1000);
    ntest("Atlantic/Madeira", 1856394000000L, 0, 0);
    ntest("Atlantic/Reykjavik", 1704067200000L, 0, 0);
    ntest("Atlantic/South_Georgia", 1704074400000L, -2*60*60*1000, 0);
    ntest("Atlantic/St_Helena", 1704067200000L, 0, 0);
    ntest("Atlantic/Stanley", 1704078000000L, -3*60*60*1000, 0);
    ntest("Australia/ACT", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/ACT", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/ACT", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1704029400000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1712420999999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1712421000000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1728145799999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1728145800000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1743870599999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1743870600000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1759595399999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1759595400000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1775320199999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1775320200000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1791044999999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1791045000000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1806769799999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1806769800000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1822494599999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1822494600000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1838219399999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Adelaide", 1838219400000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1853944199999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Adelaide", 1853944200000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Brisbane", 1704031200000L, 10*60*60*1000, 0);
    ntest("Australia/Broken_Hill", 1704029400000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1712420999999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1712421000000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1728145799999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1728145800000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1743870599999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1743870600000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1759595399999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1759595400000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1775320199999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1775320200000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1791044999999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1791045000000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1806769799999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1806769800000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1822494599999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1822494600000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1838219399999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Broken_Hill", 1838219400000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1853944199999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Broken_Hill", 1853944200000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Canberra", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/Canberra", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Currie", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/Currie", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Darwin", 1704033000000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Eucla", 1704035700000L, (8*60+45)*60*1000, 0);
    ntest("Australia/Hobart", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Hobart", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/Hobart", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/LHI", 1704027600000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1712415599999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1712415600000L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1728142199999L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1728142200000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1743865199999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1743865200000L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1759591799999L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1759591800000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1775314799999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1775314800000L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1791041399999L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1791041400000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1806764399999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1806764400000L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1822490999999L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1822491000000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1838213999999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/LHI", 1838214000000L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1853940599999L, (10*60+30)*60*1000, 0);
    ntest("Australia/LHI", 1853940600000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lindeman", 1704031200000L, 10*60*60*1000, 0);
    ntest("Australia/Lord_Howe", 1704027600000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1712415599999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1712415600000L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1728142199999L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1728142200000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1743865199999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1743865200000L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1759591799999L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1759591800000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1775314799999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1775314800000L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1791041399999L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1791041400000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1806764399999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1806764400000L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1822490999999L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1822491000000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1838213999999L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Lord_Howe", 1838214000000L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1853940599999L, (10*60+30)*60*1000, 0);
    ntest("Australia/Lord_Howe", 1853940600000L, (10*60+30)*60*1000, (0*60+30)*60*1000);
    ntest("Australia/Melbourne", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Melbourne", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/Melbourne", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/NSW", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/NSW", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/North", 1704033000000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Perth", 1704038400000L, 8*60*60*1000, 0);
    ntest("Australia/Queensland", 1704031200000L, 10*60*60*1000, 0);
    ntest("Australia/South", 1704029400000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1712420999999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1712421000000L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1728145799999L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1728145800000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1743870599999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1743870600000L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1759595399999L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1759595400000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1775320199999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1775320200000L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1791044999999L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1791045000000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1806769799999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1806769800000L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1822494599999L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1822494600000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1838219399999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/South", 1838219400000L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1853944199999L, (9*60+30)*60*1000, 0);
    ntest("Australia/South", 1853944200000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Sydney", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/Sydney", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Tasmania", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/Tasmania", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1712419200000L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1728143999999L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1743868800000L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1759593599999L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1775318400000L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1791043199999L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1806768000000L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1822492799999L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/Victoria", 1838217600000L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1853942399999L, 10*60*60*1000, 0);
    ntest("Australia/Victoria", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("Australia/West", 1704038400000L, 8*60*60*1000, 0);
    ntest("Australia/Yancowinna", 1704029400000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1712420999999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1712421000000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1728145799999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1728145800000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1743870599999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1743870600000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1759595399999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1759595400000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1775320199999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1775320200000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1791044999999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1791045000000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1806769799999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1806769800000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1822494599999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1822494600000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1838219399999L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Australia/Yancowinna", 1838219400000L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1853944199999L, (9*60+30)*60*1000, 0);
    ntest("Australia/Yancowinna", 1853944200000L, (9*60+30)*60*1000, 1*60*60*1000);
    ntest("Brazil/Acre", 1704085200000L, -5*60*60*1000, 0);
    ntest("Brazil/DeNoronha", 1704074400000L, -2*60*60*1000, 0);
    ntest("Brazil/East", 1704078000000L, -3*60*60*1000, 0);
    ntest("Brazil/West", 1704081600000L, -4*60*60*1000, 0);
    ntest("CET", 1704063600000L, 1*60*60*1000, 0);
    ntest("CET", 1711846799999L, 1*60*60*1000, 0);
    ntest("CET", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1729990800000L, 1*60*60*1000, 0);
    ntest("CET", 1743296399999L, 1*60*60*1000, 0);
    ntest("CET", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1761440400000L, 1*60*60*1000, 0);
    ntest("CET", 1774745999999L, 1*60*60*1000, 0);
    ntest("CET", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1792890000000L, 1*60*60*1000, 0);
    ntest("CET", 1806195599999L, 1*60*60*1000, 0);
    ntest("CET", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1824944400000L, 1*60*60*1000, 0);
    ntest("CET", 1837645199999L, 1*60*60*1000, 0);
    ntest("CET", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("CET", 1856394000000L, 1*60*60*1000, 0);
    ntest("CST6CDT", 1704088800000L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1710057599999L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1730617200000L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1741507199999L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1762066800000L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1772956799999L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1793516400000L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1805011199999L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1825570800000L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1836460799999L, -6*60*60*1000, 0);
    ntest("CST6CDT", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST6CDT", 1857020400000L, -6*60*60*1000, 0);
    ntest("Canada/Atlantic", 1704081600000L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1710050399999L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1710050400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1730609999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1730610000000L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1741499999999L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1741500000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1762059599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1762059600000L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1772949599999L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1772949600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1793509199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1793509200000L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1805003999999L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1805004000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1825563599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1825563600000L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1836453599999L, -4*60*60*1000, 0);
    ntest("Canada/Atlantic", 1836453600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1857013199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Canada/Atlantic", 1857013200000L, -4*60*60*1000, 0);
    ntest("Canada/Central", 1704088800000L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1710057599999L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1730617200000L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1741507199999L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1762066800000L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1772956799999L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1793516400000L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1805011199999L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1825570800000L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1836460799999L, -6*60*60*1000, 0);
    ntest("Canada/Central", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Canada/Central", 1857020400000L, -6*60*60*1000, 0);
    ntest("Canada/Eastern", 1704085200000L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1710053999999L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1730613600000L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1741503599999L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1762063200000L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1772953199999L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1793512800000L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1805007599999L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1825567200000L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1836457199999L, -5*60*60*1000, 0);
    ntest("Canada/Eastern", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Canada/Eastern", 1857016800000L, -5*60*60*1000, 0);
    ntest("Canada/Mountain", 1704092400000L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1710061199999L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1730620800000L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1741510799999L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1762070400000L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1772960399999L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1793520000000L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1805014799999L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1825574400000L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1836464399999L, -7*60*60*1000, 0);
    ntest("Canada/Mountain", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Canada/Mountain", 1857024000000L, -7*60*60*1000, 0);
    ntest("Canada/Newfoundland", 1704079800000L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1710048599999L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1710048600000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1730608199999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1730608200000L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1741498199999L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1741498200000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1762057799999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1762057800000L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1772947799999L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1772947800000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1793507399999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1793507400000L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1805002199999L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1805002200000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1825561799999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1825561800000L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1836451799999L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Newfoundland", 1836451800000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1857011399999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("Canada/Newfoundland", 1857011400000L, -(3*60+30)*60*1000, 0);
    ntest("Canada/Pacific", 1704096000000L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1710064799999L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1730624400000L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1741514399999L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1762074000000L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1772963999999L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1793523600000L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1805018399999L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1825578000000L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1836467999999L, -8*60*60*1000, 0);
    ntest("Canada/Pacific", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Canada/Pacific", 1857027600000L, -8*60*60*1000, 0);
    ntest("Canada/Saskatchewan", 1704088800000L, -6*60*60*1000, 0);
    ntest("Canada/Yukon", 1704092400000L, -7*60*60*1000, 0);
    ntest("Chile/Continental", 1704078000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1712458799999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1712458800000L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1725767999999L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1725768000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1743908399999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1743908400000L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1757217599999L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1757217600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1775357999999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1775358000000L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1788667199999L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1788667200000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1806807599999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1806807600000L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1820116799999L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1820116800000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1838257199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/Continental", 1838257200000L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1851566399999L, -4*60*60*1000, 0);
    ntest("Chile/Continental", 1851566400000L, -4*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1704085200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1712458799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1712458800000L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1725767999999L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1725768000000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1743908399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1743908400000L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1757217599999L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1757217600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1775357999999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1775358000000L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1788667199999L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1788667200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1806807599999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1806807600000L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1820116799999L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1820116800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1838257199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Chile/EasterIsland", 1838257200000L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1851566399999L, -6*60*60*1000, 0);
    ntest("Chile/EasterIsland", 1851566400000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1704085200000L, -5*60*60*1000, 0);
    ntest("Cuba", 1710046799999L, -5*60*60*1000, 0);
    ntest("Cuba", 1710046800000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1730609999999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1730610000000L, -5*60*60*1000, 0);
    ntest("Cuba", 1741496399999L, -5*60*60*1000, 0);
    ntest("Cuba", 1741496400000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1762059599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1762059600000L, -5*60*60*1000, 0);
    ntest("Cuba", 1772945999999L, -5*60*60*1000, 0);
    ntest("Cuba", 1772946000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1793509199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1793509200000L, -5*60*60*1000, 0);
    ntest("Cuba", 1805000399999L, -5*60*60*1000, 0);
    ntest("Cuba", 1805000400000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1825563599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1825563600000L, -5*60*60*1000, 0);
    ntest("Cuba", 1836449999999L, -5*60*60*1000, 0);
    ntest("Cuba", 1836450000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1857013199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("Cuba", 1857013200000L, -5*60*60*1000, 0);
    ntest("EET", 1704060000000L, 2*60*60*1000, 0);
    ntest("EET", 1711846799999L, 2*60*60*1000, 0);
    ntest("EET", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1729990800000L, 2*60*60*1000, 0);
    ntest("EET", 1743296399999L, 2*60*60*1000, 0);
    ntest("EET", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1761440400000L, 2*60*60*1000, 0);
    ntest("EET", 1774745999999L, 2*60*60*1000, 0);
    ntest("EET", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1792890000000L, 2*60*60*1000, 0);
    ntest("EET", 1806195599999L, 2*60*60*1000, 0);
    ntest("EET", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1824944400000L, 2*60*60*1000, 0);
    ntest("EET", 1837645199999L, 2*60*60*1000, 0);
    ntest("EET", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("EET", 1856394000000L, 2*60*60*1000, 0);
    ntest("EST5EDT", 1704085200000L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1710053999999L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1730613600000L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1741503599999L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1762063200000L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1772953199999L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1793512800000L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1805007599999L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1825567200000L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1836457199999L, -5*60*60*1000, 0);
    ntest("EST5EDT", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("EST5EDT", 1857016800000L, -5*60*60*1000, 0);
    ntest("Egypt", 1704060000000L, 2*60*60*1000, 0);
    ntest("Egypt", 1714082399999L, 2*60*60*1000, 0);
    ntest("Egypt", 1714082400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1730408399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1730408400000L, 2*60*60*1000, 0);
    ntest("Egypt", 1745531999999L, 2*60*60*1000, 0);
    ntest("Egypt", 1745532000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1761857999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1761858000000L, 2*60*60*1000, 0);
    ntest("Egypt", 1776981599999L, 2*60*60*1000, 0);
    ntest("Egypt", 1776981600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1793307599999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1793307600000L, 2*60*60*1000, 0);
    ntest("Egypt", 1809035999999L, 2*60*60*1000, 0);
    ntest("Egypt", 1809036000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1824757199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1824757200000L, 2*60*60*1000, 0);
    ntest("Egypt", 1840485599999L, 2*60*60*1000, 0);
    ntest("Egypt", 1840485600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1856206799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Egypt", 1856206800000L, 2*60*60*1000, 0);
    ntest("Eire", 1704067200000L, 0, 0);
    ntest("Eire", 1711846799999L, 0, 0);
    ntest("Eire", 1711846800000L, 0, 1*60*60*1000);
    ntest("Eire", 1729990799999L, 0, 1*60*60*1000);
    ntest("Eire", 1729990800000L, 0, 0);
    ntest("Eire", 1743296399999L, 0, 0);
    ntest("Eire", 1743296400000L, 0, 1*60*60*1000);
    ntest("Eire", 1761440399999L, 0, 1*60*60*1000);
    ntest("Eire", 1761440400000L, 0, 0);
    ntest("Eire", 1774745999999L, 0, 0);
    ntest("Eire", 1774746000000L, 0, 1*60*60*1000);
    ntest("Eire", 1792889999999L, 0, 1*60*60*1000);
    ntest("Eire", 1792890000000L, 0, 0);
    ntest("Eire", 1806195599999L, 0, 0);
    ntest("Eire", 1806195600000L, 0, 1*60*60*1000);
    ntest("Eire", 1824944399999L, 0, 1*60*60*1000);
    ntest("Eire", 1824944400000L, 0, 0);
    ntest("Eire", 1837645199999L, 0, 0);
    ntest("Eire", 1837645200000L, 0, 1*60*60*1000);
    ntest("Eire", 1856393999999L, 0, 1*60*60*1000);
    ntest("Eire", 1856394000000L, 0, 0);
    ntest("Etc/GMT", 1704067200000L, 0, 0);
    ntest("Etc/GMT+0", 1704067200000L, 0, 0);
    ntest("Etc/GMT+1", 1704070800000L, -1*60*60*1000, 0);
    ntest("Etc/GMT+10", 1704103200000L, -10*60*60*1000, 0);
    ntest("Etc/GMT+11", 1704106800000L, -11*60*60*1000, 0);
    ntest("Etc/GMT+12", 1704110400000L, -12*60*60*1000, 0);
    ntest("Etc/GMT+2", 1704074400000L, -2*60*60*1000, 0);
    ntest("Etc/GMT+3", 1704078000000L, -3*60*60*1000, 0);
    ntest("Etc/GMT+4", 1704081600000L, -4*60*60*1000, 0);
    ntest("Etc/GMT+5", 1704085200000L, -5*60*60*1000, 0);
    ntest("Etc/GMT+6", 1704088800000L, -6*60*60*1000, 0);
    ntest("Etc/GMT+7", 1704092400000L, -7*60*60*1000, 0);
    ntest("Etc/GMT+8", 1704096000000L, -8*60*60*1000, 0);
    ntest("Etc/GMT+9", 1704099600000L, -9*60*60*1000, 0);
    ntest("Etc/GMT-0", 1704067200000L, 0, 0);
    ntest("Etc/GMT-1", 1704063600000L, 1*60*60*1000, 0);
    ntest("Etc/GMT-10", 1704031200000L, 10*60*60*1000, 0);
    ntest("Etc/GMT-11", 1704027600000L, 11*60*60*1000, 0);
    ntest("Etc/GMT-12", 1704024000000L, 12*60*60*1000, 0);
    ntest("Etc/GMT-13", 1704020400000L, 13*60*60*1000, 0);
    ntest("Etc/GMT-14", 1704016800000L, 14*60*60*1000, 0);
    ntest("Etc/GMT-2", 1704060000000L, 2*60*60*1000, 0);
    ntest("Etc/GMT-3", 1704056400000L, 3*60*60*1000, 0);
    ntest("Etc/GMT-4", 1704052800000L, 4*60*60*1000, 0);
    ntest("Etc/GMT-5", 1704049200000L, 5*60*60*1000, 0);
    ntest("Etc/GMT-6", 1704045600000L, 6*60*60*1000, 0);
    ntest("Etc/GMT-7", 1704042000000L, 7*60*60*1000, 0);
    ntest("Etc/GMT-8", 1704038400000L, 8*60*60*1000, 0);
    ntest("Etc/GMT-9", 1704034800000L, 9*60*60*1000, 0);
    ntest("Etc/GMT0", 1704067200000L, 0, 0);
    ntest("Etc/Greenwich", 1704067200000L, 0, 0);
    ntest("Etc/UCT", 1704067200000L, 0, 0);
    ntest("Etc/UTC", 1704067200000L, 0, 0);
    ntest("Etc/Universal", 1704067200000L, 0, 0);
    ntest("Etc/Zulu", 1704067200000L, 0, 0);
    ntest("Europe/Amsterdam", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Amsterdam", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Amsterdam", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Andorra", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Andorra", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Astrakhan", 1704052800000L, 4*60*60*1000, 0);
    ntest("Europe/Athens", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Athens", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Athens", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Belfast", 1704067200000L, 0, 0);
    ntest("Europe/Belfast", 1711846799999L, 0, 0);
    ntest("Europe/Belfast", 1711846800000L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1729990799999L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1729990800000L, 0, 0);
    ntest("Europe/Belfast", 1743296399999L, 0, 0);
    ntest("Europe/Belfast", 1743296400000L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1761440399999L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1761440400000L, 0, 0);
    ntest("Europe/Belfast", 1774745999999L, 0, 0);
    ntest("Europe/Belfast", 1774746000000L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1792889999999L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1792890000000L, 0, 0);
    ntest("Europe/Belfast", 1806195599999L, 0, 0);
    ntest("Europe/Belfast", 1806195600000L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1824944399999L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1824944400000L, 0, 0);
    ntest("Europe/Belfast", 1837645199999L, 0, 0);
    ntest("Europe/Belfast", 1837645200000L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1856393999999L, 0, 1*60*60*1000);
    ntest("Europe/Belfast", 1856394000000L, 0, 0);
    ntest("Europe/Belgrade", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Belgrade", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Belgrade", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1743296399999L, 1*60*60*1000, 0);
  }
  static void ntest4() {
    ntest("Europe/Berlin", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Berlin", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Berlin", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Bratislava", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bratislava", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Brussels", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Brussels", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Bucharest", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Bucharest", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Bucharest", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Budapest", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Budapest", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Budapest", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Busingen", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Busingen", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Chisinau", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1711843199999L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1711843200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1729987199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1729987200000L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1743292799999L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1743292800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1761436799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1761436800000L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1774742399999L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1774742400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1792886399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1792886400000L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1806191999999L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1806192000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1824940799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1824940800000L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1837641599999L, 2*60*60*1000, 0);
    ntest("Europe/Chisinau", 1837641600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1856390399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Chisinau", 1856390400000L, 2*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Copenhagen", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Copenhagen", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Dublin", 1704067200000L, 0, 0);
    ntest("Europe/Dublin", 1711846799999L, 0, 0);
    ntest("Europe/Dublin", 1711846800000L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1729990799999L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1729990800000L, 0, 0);
    ntest("Europe/Dublin", 1743296399999L, 0, 0);
    ntest("Europe/Dublin", 1743296400000L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1761440399999L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1761440400000L, 0, 0);
    ntest("Europe/Dublin", 1774745999999L, 0, 0);
    ntest("Europe/Dublin", 1774746000000L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1792889999999L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1792890000000L, 0, 0);
    ntest("Europe/Dublin", 1806195599999L, 0, 0);
    ntest("Europe/Dublin", 1806195600000L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1824944399999L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1824944400000L, 0, 0);
    ntest("Europe/Dublin", 1837645199999L, 0, 0);
    ntest("Europe/Dublin", 1837645200000L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1856393999999L, 0, 1*60*60*1000);
    ntest("Europe/Dublin", 1856394000000L, 0, 0);
    ntest("Europe/Gibraltar", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Gibraltar", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Gibraltar", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Guernsey", 1704067200000L, 0, 0);
    ntest("Europe/Guernsey", 1711846799999L, 0, 0);
    ntest("Europe/Guernsey", 1711846800000L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1729990799999L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1729990800000L, 0, 0);
    ntest("Europe/Guernsey", 1743296399999L, 0, 0);
    ntest("Europe/Guernsey", 1743296400000L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1761440399999L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1761440400000L, 0, 0);
    ntest("Europe/Guernsey", 1774745999999L, 0, 0);
    ntest("Europe/Guernsey", 1774746000000L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1792889999999L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1792890000000L, 0, 0);
    ntest("Europe/Guernsey", 1806195599999L, 0, 0);
    ntest("Europe/Guernsey", 1806195600000L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1824944399999L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1824944400000L, 0, 0);
    ntest("Europe/Guernsey", 1837645199999L, 0, 0);
    ntest("Europe/Guernsey", 1837645200000L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1856393999999L, 0, 1*60*60*1000);
    ntest("Europe/Guernsey", 1856394000000L, 0, 0);
    ntest("Europe/Helsinki", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Helsinki", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Helsinki", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Isle_of_Man", 1704067200000L, 0, 0);
    ntest("Europe/Isle_of_Man", 1711846799999L, 0, 0);
    ntest("Europe/Isle_of_Man", 1711846800000L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1729990799999L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1729990800000L, 0, 0);
    ntest("Europe/Isle_of_Man", 1743296399999L, 0, 0);
    ntest("Europe/Isle_of_Man", 1743296400000L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1761440399999L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1761440400000L, 0, 0);
    ntest("Europe/Isle_of_Man", 1774745999999L, 0, 0);
    ntest("Europe/Isle_of_Man", 1774746000000L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1792889999999L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1792890000000L, 0, 0);
    ntest("Europe/Isle_of_Man", 1806195599999L, 0, 0);
    ntest("Europe/Isle_of_Man", 1806195600000L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1824944399999L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1824944400000L, 0, 0);
    ntest("Europe/Isle_of_Man", 1837645199999L, 0, 0);
    ntest("Europe/Isle_of_Man", 1837645200000L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1856393999999L, 0, 1*60*60*1000);
    ntest("Europe/Isle_of_Man", 1856394000000L, 0, 0);
    ntest("Europe/Istanbul", 1704056400000L, 3*60*60*1000, 0);
    ntest("Europe/Jersey", 1704067200000L, 0, 0);
    ntest("Europe/Jersey", 1711846799999L, 0, 0);
    ntest("Europe/Jersey", 1711846800000L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1729990799999L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1729990800000L, 0, 0);
    ntest("Europe/Jersey", 1743296399999L, 0, 0);
    ntest("Europe/Jersey", 1743296400000L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1761440399999L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1761440400000L, 0, 0);
    ntest("Europe/Jersey", 1774745999999L, 0, 0);
    ntest("Europe/Jersey", 1774746000000L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1792889999999L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1792890000000L, 0, 0);
    ntest("Europe/Jersey", 1806195599999L, 0, 0);
    ntest("Europe/Jersey", 1806195600000L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1824944399999L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1824944400000L, 0, 0);
    ntest("Europe/Jersey", 1837645199999L, 0, 0);
    ntest("Europe/Jersey", 1837645200000L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1856393999999L, 0, 1*60*60*1000);
    ntest("Europe/Jersey", 1856394000000L, 0, 0);
    ntest("Europe/Kaliningrad", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Kiev", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kiev", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Kirov", 1704056400000L, 3*60*60*1000, 0);
    ntest("Europe/Kyiv", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Kyiv", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Kyiv", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Lisbon", 1704067200000L, 0, 0);
    ntest("Europe/Lisbon", 1711846799999L, 0, 0);
    ntest("Europe/Lisbon", 1711846800000L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1729990799999L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1729990800000L, 0, 0);
    ntest("Europe/Lisbon", 1743296399999L, 0, 0);
    ntest("Europe/Lisbon", 1743296400000L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1761440399999L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1761440400000L, 0, 0);
    ntest("Europe/Lisbon", 1774745999999L, 0, 0);
    ntest("Europe/Lisbon", 1774746000000L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1792889999999L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1792890000000L, 0, 0);
    ntest("Europe/Lisbon", 1806195599999L, 0, 0);
    ntest("Europe/Lisbon", 1806195600000L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1824944399999L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1824944400000L, 0, 0);
    ntest("Europe/Lisbon", 1837645199999L, 0, 0);
    ntest("Europe/Lisbon", 1837645200000L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1856393999999L, 0, 1*60*60*1000);
    ntest("Europe/Lisbon", 1856394000000L, 0, 0);
    ntest("Europe/Ljubljana", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Ljubljana", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Ljubljana", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/London", 1704067200000L, 0, 0);
    ntest("Europe/London", 1711846799999L, 0, 0);
    ntest("Europe/London", 1711846800000L, 0, 1*60*60*1000);
    ntest("Europe/London", 1729990799999L, 0, 1*60*60*1000);
    ntest("Europe/London", 1729990800000L, 0, 0);
    ntest("Europe/London", 1743296399999L, 0, 0);
    ntest("Europe/London", 1743296400000L, 0, 1*60*60*1000);
    ntest("Europe/London", 1761440399999L, 0, 1*60*60*1000);
    ntest("Europe/London", 1761440400000L, 0, 0);
    ntest("Europe/London", 1774745999999L, 0, 0);
    ntest("Europe/London", 1774746000000L, 0, 1*60*60*1000);
    ntest("Europe/London", 1792889999999L, 0, 1*60*60*1000);
    ntest("Europe/London", 1792890000000L, 0, 0);
    ntest("Europe/London", 1806195599999L, 0, 0);
    ntest("Europe/London", 1806195600000L, 0, 1*60*60*1000);
    ntest("Europe/London", 1824944399999L, 0, 1*60*60*1000);
    ntest("Europe/London", 1824944400000L, 0, 0);
    ntest("Europe/London", 1837645199999L, 0, 0);
    ntest("Europe/London", 1837645200000L, 0, 1*60*60*1000);
    ntest("Europe/London", 1856393999999L, 0, 1*60*60*1000);
    ntest("Europe/London", 1856394000000L, 0, 0);
    ntest("Europe/Luxembourg", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Luxembourg", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Luxembourg", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Madrid", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Madrid", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Malta", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Malta", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Mariehamn", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Mariehamn", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Minsk", 1704056400000L, 3*60*60*1000, 0);
    ntest("Europe/Monaco", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Monaco", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Monaco", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Moscow", 1704056400000L, 3*60*60*1000, 0);
    ntest("Europe/Nicosia", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Nicosia", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Nicosia", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Oslo", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Oslo", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Oslo", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Paris", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Paris", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Podgorica", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Podgorica", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Prague", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Prague", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Riga", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Riga", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Riga", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Rome", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Rome", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Rome", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Samara", 1704052800000L, 4*60*60*1000, 0);
    ntest("Europe/San_Marino", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/San_Marino", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/San_Marino", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Sarajevo", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sarajevo", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Saratov", 1704052800000L, 4*60*60*1000, 0);
    ntest("Europe/Simferopol", 1704056400000L, 3*60*60*1000, 0);
    ntest("Europe/Skopje", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Skopje", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Skopje", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Sofia", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Sofia", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Sofia", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Stockholm", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Stockholm", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Stockholm", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Tallinn", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Tallinn", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tallinn", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Tirane", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Tirane", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tirane", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1711843199999L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1711843200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1729987199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1729987200000L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1743292799999L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1743292800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1761436799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1761436800000L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1774742399999L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1774742400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1792886399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1792886400000L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1806191999999L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1806192000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1824940799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1824940800000L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1837641599999L, 2*60*60*1000, 0);
    ntest("Europe/Tiraspol", 1837641600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1856390399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Tiraspol", 1856390400000L, 2*60*60*1000, 0);
    ntest("Europe/Ulyanovsk", 1704052800000L, 4*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Uzhgorod", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Uzhgorod", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Vaduz", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Vaduz", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vaduz", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Vatican", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vatican", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Vienna", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vienna", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Vilnius", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Vilnius", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Vilnius", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Volgograd", 1704056400000L, 3*60*60*1000, 0);
    ntest("Europe/Warsaw", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Warsaw", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Warsaw", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1761440400000L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Zagreb", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zagreb", 1856394000000L, 1*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1704060000000L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1711846799999L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1711846800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1729990799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1729990800000L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1743296399999L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1743296400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1761440399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1761440400000L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1774745999999L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1774746000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1792889999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1792890000000L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1806195599999L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1806195600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1824944399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1824944400000L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1837645199999L, 2*60*60*1000, 0);
    ntest("Europe/Zaporozhye", 1837645200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1856393999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zaporozhye", 1856394000000L, 2*60*60*1000, 0);
    ntest("Europe/Zurich", 1704063600000L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1711846799999L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1729990800000L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1743296399999L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1761440400000L, 1*60*60*1000, 0);
  }
  static void ntest5() {
    ntest("Europe/Zurich", 1774745999999L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1792890000000L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1806195599999L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1824944400000L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1837645199999L, 1*60*60*1000, 0);
    ntest("Europe/Zurich", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Europe/Zurich", 1856394000000L, 1*60*60*1000, 0);
    ntest("GB", 1704067200000L, 0, 0);
    ntest("GB", 1711846799999L, 0, 0);
    ntest("GB", 1711846800000L, 0, 1*60*60*1000);
    ntest("GB", 1729990799999L, 0, 1*60*60*1000);
    ntest("GB", 1729990800000L, 0, 0);
    ntest("GB", 1743296399999L, 0, 0);
    ntest("GB", 1743296400000L, 0, 1*60*60*1000);
    ntest("GB", 1761440399999L, 0, 1*60*60*1000);
    ntest("GB", 1761440400000L, 0, 0);
    ntest("GB", 1774745999999L, 0, 0);
    ntest("GB", 1774746000000L, 0, 1*60*60*1000);
    ntest("GB", 1792889999999L, 0, 1*60*60*1000);
    ntest("GB", 1792890000000L, 0, 0);
    ntest("GB", 1806195599999L, 0, 0);
    ntest("GB", 1806195600000L, 0, 1*60*60*1000);
    ntest("GB", 1824944399999L, 0, 1*60*60*1000);
    ntest("GB", 1824944400000L, 0, 0);
    ntest("GB", 1837645199999L, 0, 0);
    ntest("GB", 1837645200000L, 0, 1*60*60*1000);
    ntest("GB", 1856393999999L, 0, 1*60*60*1000);
    ntest("GB", 1856394000000L, 0, 0);
    ntest("GB-Eire", 1704067200000L, 0, 0);
    ntest("GB-Eire", 1711846799999L, 0, 0);
    ntest("GB-Eire", 1711846800000L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1729990799999L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1729990800000L, 0, 0);
    ntest("GB-Eire", 1743296399999L, 0, 0);
    ntest("GB-Eire", 1743296400000L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1761440399999L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1761440400000L, 0, 0);
    ntest("GB-Eire", 1774745999999L, 0, 0);
    ntest("GB-Eire", 1774746000000L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1792889999999L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1792890000000L, 0, 0);
    ntest("GB-Eire", 1806195599999L, 0, 0);
    ntest("GB-Eire", 1806195600000L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1824944399999L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1824944400000L, 0, 0);
    ntest("GB-Eire", 1837645199999L, 0, 0);
    ntest("GB-Eire", 1837645200000L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1856393999999L, 0, 1*60*60*1000);
    ntest("GB-Eire", 1856394000000L, 0, 0);
    ntest("GMT", 1704067200000L, 0, 0);
    ntest("GMT0", 1704067200000L, 0, 0);
    ntest("Greenwich", 1704067200000L, 0, 0);
    ntest("Hongkong", 1704038400000L, 8*60*60*1000, 0);
    ntest("Iceland", 1704067200000L, 0, 0);
    ntest("Indian/Antananarivo", 1704056400000L, 3*60*60*1000, 0);
    ntest("Indian/Chagos", 1704045600000L, 6*60*60*1000, 0);
    ntest("Indian/Christmas", 1704042000000L, 7*60*60*1000, 0);
    ntest("Indian/Cocos", 1704043800000L, (6*60+30)*60*1000, 0);
    ntest("Indian/Comoro", 1704056400000L, 3*60*60*1000, 0);
    ntest("Indian/Kerguelen", 1704049200000L, 5*60*60*1000, 0);
    ntest("Indian/Mahe", 1704052800000L, 4*60*60*1000, 0);
    ntest("Indian/Maldives", 1704049200000L, 5*60*60*1000, 0);
    ntest("Indian/Mauritius", 1704052800000L, 4*60*60*1000, 0);
    ntest("Indian/Mayotte", 1704056400000L, 3*60*60*1000, 0);
    ntest("Indian/Reunion", 1704052800000L, 4*60*60*1000, 0);
    ntest("Iran", 1704054600000L, (3*60+30)*60*1000, 0);
    ntest("Israel", 1704060000000L, 2*60*60*1000, 0);
    ntest("Israel", 1711670399999L, 2*60*60*1000, 0);
    ntest("Israel", 1711670400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1729983599999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1729983600000L, 2*60*60*1000, 0);
    ntest("Israel", 1743119999999L, 2*60*60*1000, 0);
    ntest("Israel", 1743120000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1761433199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1761433200000L, 2*60*60*1000, 0);
    ntest("Israel", 1774569599999L, 2*60*60*1000, 0);
    ntest("Israel", 1774569600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1792882799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1792882800000L, 2*60*60*1000, 0);
    ntest("Israel", 1806019199999L, 2*60*60*1000, 0);
    ntest("Israel", 1806019200000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1824937199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1824937200000L, 2*60*60*1000, 0);
    ntest("Israel", 1837468799999L, 2*60*60*1000, 0);
    ntest("Israel", 1837468800000L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1856386799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("Israel", 1856386800000L, 2*60*60*1000, 0);
    ntest("Jamaica", 1704085200000L, -5*60*60*1000, 0);
    ntest("Japan", 1704034800000L, 9*60*60*1000, 0);
    ntest("Kwajalein", 1704024000000L, 12*60*60*1000, 0);
    ntest("Libya", 1704060000000L, 2*60*60*1000, 0);
    ntest("MET", 1704063600000L, 1*60*60*1000, 0);
    ntest("MET", 1711846799999L, 1*60*60*1000, 0);
    ntest("MET", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1729990800000L, 1*60*60*1000, 0);
    ntest("MET", 1743296399999L, 1*60*60*1000, 0);
    ntest("MET", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1761440400000L, 1*60*60*1000, 0);
    ntest("MET", 1774745999999L, 1*60*60*1000, 0);
    ntest("MET", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1792890000000L, 1*60*60*1000, 0);
    ntest("MET", 1806195599999L, 1*60*60*1000, 0);
    ntest("MET", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1824944400000L, 1*60*60*1000, 0);
    ntest("MET", 1837645199999L, 1*60*60*1000, 0);
    ntest("MET", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("MET", 1856394000000L, 1*60*60*1000, 0);
    ntest("MST7MDT", 1704092400000L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1710061199999L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1730620800000L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1741510799999L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1762070400000L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1772960399999L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1793520000000L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1805014799999L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1825574400000L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1836464399999L, -7*60*60*1000, 0);
    ntest("MST7MDT", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("MST7MDT", 1857024000000L, -7*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1704096000000L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1710064799999L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1730624400000L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1741514399999L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1762074000000L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1772963999999L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1793523600000L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1805018399999L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1825578000000L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1836467999999L, -8*60*60*1000, 0);
    ntest("Mexico/BajaNorte", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("Mexico/BajaNorte", 1857027600000L, -8*60*60*1000, 0);
    ntest("Mexico/BajaSur", 1704092400000L, -7*60*60*1000, 0);
    ntest("Mexico/General", 1704088800000L, -6*60*60*1000, 0);
    ntest("NZ", 1704020400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1712411999999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1712412000000L, 12*60*60*1000, 0);
    ntest("NZ", 1727531999999L, 12*60*60*1000, 0);
    ntest("NZ", 1727532000000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1743861599999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1743861600000L, 12*60*60*1000, 0);
    ntest("NZ", 1758981599999L, 12*60*60*1000, 0);
    ntest("NZ", 1758981600000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1775311199999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1775311200000L, 12*60*60*1000, 0);
    ntest("NZ", 1790431199999L, 12*60*60*1000, 0);
    ntest("NZ", 1790431200000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1806760799999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1806760800000L, 12*60*60*1000, 0);
    ntest("NZ", 1821880799999L, 12*60*60*1000, 0);
    ntest("NZ", 1821880800000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1838210399999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ", 1838210400000L, 12*60*60*1000, 0);
    ntest("NZ", 1853330399999L, 12*60*60*1000, 0);
    ntest("NZ", 1853330400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1704017700000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1712411999999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1712412000000L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1727531999999L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1727532000000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1743861599999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1743861600000L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1758981599999L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1758981600000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1775311199999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1775311200000L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1790431199999L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1790431200000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1806760799999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1806760800000L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1821880799999L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1821880800000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1838210399999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("NZ-CHAT", 1838210400000L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1853330399999L, (12*60+45)*60*1000, 0);
    ntest("NZ-CHAT", 1853330400000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Navajo", 1704092400000L, -7*60*60*1000, 0);
    ntest("Navajo", 1710061199999L, -7*60*60*1000, 0);
    ntest("Navajo", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1730620800000L, -7*60*60*1000, 0);
    ntest("Navajo", 1741510799999L, -7*60*60*1000, 0);
    ntest("Navajo", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1762070400000L, -7*60*60*1000, 0);
    ntest("Navajo", 1772960399999L, -7*60*60*1000, 0);
    ntest("Navajo", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1793520000000L, -7*60*60*1000, 0);
    ntest("Navajo", 1805014799999L, -7*60*60*1000, 0);
    ntest("Navajo", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1825574400000L, -7*60*60*1000, 0);
    ntest("Navajo", 1836464399999L, -7*60*60*1000, 0);
    ntest("Navajo", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("Navajo", 1857024000000L, -7*60*60*1000, 0);
    ntest("PRC", 1704038400000L, 8*60*60*1000, 0);
    ntest("PST8PDT", 1704096000000L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1710064799999L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1730624400000L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1741514399999L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1762074000000L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1772963999999L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1793523600000L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1805018399999L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1825578000000L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1836467999999L, -8*60*60*1000, 0);
    ntest("PST8PDT", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST8PDT", 1857027600000L, -8*60*60*1000, 0);
    ntest("Pacific/Apia", 1704020400000L, 13*60*60*1000, 0);
    ntest("Pacific/Auckland", 1704020400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1712411999999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1712412000000L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1727531999999L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1727532000000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1743861599999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1743861600000L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1758981599999L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1758981600000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1775311199999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1775311200000L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1790431199999L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1790431200000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1806760799999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1806760800000L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1821880799999L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1821880800000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1838210399999L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Auckland", 1838210400000L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1853330399999L, 12*60*60*1000, 0);
    ntest("Pacific/Auckland", 1853330400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Bougainville", 1704027600000L, 11*60*60*1000, 0);
    ntest("Pacific/Chatham", 1704017700000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1712411999999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1712412000000L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1727531999999L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1727532000000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1743861599999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1743861600000L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1758981599999L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1758981600000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1775311199999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1775311200000L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1790431199999L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1790431200000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1806760799999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1806760800000L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1821880799999L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1821880800000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1838210399999L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chatham", 1838210400000L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1853330399999L, (12*60+45)*60*1000, 0);
    ntest("Pacific/Chatham", 1853330400000L, (12*60+45)*60*1000, 1*60*60*1000);
    ntest("Pacific/Chuuk", 1704031200000L, 10*60*60*1000, 0);
    ntest("Pacific/Easter", 1704085200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1712458799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1712458800000L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1725767999999L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1725768000000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1743908399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1743908400000L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1757217599999L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1757217600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1775357999999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1775358000000L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1788667199999L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1788667200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1806807599999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1806807600000L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1820116799999L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1820116800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1838257199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Easter", 1838257200000L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1851566399999L, -6*60*60*1000, 0);
    ntest("Pacific/Easter", 1851566400000L, -6*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Efate", 1704027600000L, 11*60*60*1000, 0);
    ntest("Pacific/Enderbury", 1704020400000L, 13*60*60*1000, 0);
    ntest("Pacific/Fakaofo", 1704020400000L, 13*60*60*1000, 0);
    ntest("Pacific/Fiji", 1704024000000L, 12*60*60*1000, 0);
    ntest("Pacific/Funafuti", 1704024000000L, 12*60*60*1000, 0);
    ntest("Pacific/Galapagos", 1704088800000L, -6*60*60*1000, 0);
    ntest("Pacific/Gambier", 1704099600000L, -9*60*60*1000, 0);
    ntest("Pacific/Guadalcanal", 1704027600000L, 11*60*60*1000, 0);
    ntest("Pacific/Guam", 1704031200000L, 10*60*60*1000, 0);
    ntest("Pacific/Honolulu", 1704103200000L, -10*60*60*1000, 0);
    ntest("Pacific/Johnston", 1704103200000L, -10*60*60*1000, 0);
    ntest("Pacific/Kanton", 1704020400000L, 13*60*60*1000, 0);
    ntest("Pacific/Kiritimati", 1704016800000L, 14*60*60*1000, 0);
    ntest("Pacific/Kosrae", 1704027600000L, 11*60*60*1000, 0);
    ntest("Pacific/Kwajalein", 1704024000000L, 12*60*60*1000, 0);
    ntest("Pacific/Majuro", 1704024000000L, 12*60*60*1000, 0);
    ntest("Pacific/Marquesas", 1704101400000L, -(9*60+30)*60*1000, 0);
    ntest("Pacific/Midway", 1704106800000L, -11*60*60*1000, 0);
    ntest("Pacific/Nauru", 1704024000000L, 12*60*60*1000, 0);
    ntest("Pacific/Niue", 1704106800000L, -11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1704024000000L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1712415599999L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1712415600000L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1728140399999L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1728140400000L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1743865199999L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1743865200000L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1759589999999L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1759590000000L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1775314799999L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1775314800000L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1791039599999L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1791039600000L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1806764399999L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1806764400000L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1822489199999L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1822489200000L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1838213999999L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Norfolk", 1838214000000L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1853938799999L, 11*60*60*1000, 0);
    ntest("Pacific/Norfolk", 1853938800000L, 11*60*60*1000, 1*60*60*1000);
    ntest("Pacific/Noumea", 1704027600000L, 11*60*60*1000, 0);
    ntest("Pacific/Pago_Pago", 1704106800000L, -11*60*60*1000, 0);
    ntest("Pacific/Palau", 1704034800000L, 9*60*60*1000, 0);
    ntest("Pacific/Pitcairn", 1704096000000L, -8*60*60*1000, 0);
    ntest("Pacific/Pohnpei", 1704027600000L, 11*60*60*1000, 0);
    ntest("Pacific/Ponape", 1704027600000L, 11*60*60*1000, 0);
    ntest("Pacific/Port_Moresby", 1704031200000L, 10*60*60*1000, 0);
    ntest("Pacific/Rarotonga", 1704103200000L, -10*60*60*1000, 0);
    ntest("Pacific/Saipan", 1704031200000L, 10*60*60*1000, 0);
    ntest("Pacific/Samoa", 1704106800000L, -11*60*60*1000, 0);
    ntest("Pacific/Tahiti", 1704103200000L, -10*60*60*1000, 0);
    ntest("Pacific/Tarawa", 1704024000000L, 12*60*60*1000, 0);
    ntest("Pacific/Tongatapu", 1704020400000L, 13*60*60*1000, 0);
    ntest("Pacific/Truk", 1704031200000L, 10*60*60*1000, 0);
    ntest("Pacific/Wake", 1704024000000L, 12*60*60*1000, 0);
    ntest("Pacific/Wallis", 1704024000000L, 12*60*60*1000, 0);
    ntest("Pacific/Yap", 1704031200000L, 10*60*60*1000, 0);
    ntest("Poland", 1704063600000L, 1*60*60*1000, 0);
    ntest("Poland", 1711846799999L, 1*60*60*1000, 0);
    ntest("Poland", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1729990800000L, 1*60*60*1000, 0);
    ntest("Poland", 1743296399999L, 1*60*60*1000, 0);
    ntest("Poland", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1761440400000L, 1*60*60*1000, 0);
    ntest("Poland", 1774745999999L, 1*60*60*1000, 0);
    ntest("Poland", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1792890000000L, 1*60*60*1000, 0);
    ntest("Poland", 1806195599999L, 1*60*60*1000, 0);
    ntest("Poland", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1824944400000L, 1*60*60*1000, 0);
    ntest("Poland", 1837645199999L, 1*60*60*1000, 0);
    ntest("Poland", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("Poland", 1856394000000L, 1*60*60*1000, 0);
    ntest("Portugal", 1704067200000L, 0, 0);
    ntest("Portugal", 1711846799999L, 0, 0);
    ntest("Portugal", 1711846800000L, 0, 1*60*60*1000);
    ntest("Portugal", 1729990799999L, 0, 1*60*60*1000);
    ntest("Portugal", 1729990800000L, 0, 0);
    ntest("Portugal", 1743296399999L, 0, 0);
    ntest("Portugal", 1743296400000L, 0, 1*60*60*1000);
    ntest("Portugal", 1761440399999L, 0, 1*60*60*1000);
    ntest("Portugal", 1761440400000L, 0, 0);
    ntest("Portugal", 1774745999999L, 0, 0);
    ntest("Portugal", 1774746000000L, 0, 1*60*60*1000);
    ntest("Portugal", 1792889999999L, 0, 1*60*60*1000);
    ntest("Portugal", 1792890000000L, 0, 0);
    ntest("Portugal", 1806195599999L, 0, 0);
    ntest("Portugal", 1806195600000L, 0, 1*60*60*1000);
    ntest("Portugal", 1824944399999L, 0, 1*60*60*1000);
    ntest("Portugal", 1824944400000L, 0, 0);
    ntest("Portugal", 1837645199999L, 0, 0);
    ntest("Portugal", 1837645200000L, 0, 1*60*60*1000);
    ntest("Portugal", 1856393999999L, 0, 1*60*60*1000);
    ntest("Portugal", 1856394000000L, 0, 0);
    ntest("ROK", 1704034800000L, 9*60*60*1000, 0);
    ntest("Singapore", 1704038400000L, 8*60*60*1000, 0);
    ntest("SystemV/AST4", 1704081600000L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1704081600000L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1714283999999L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1714284000000L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1730005199999L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1730005200000L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1745733599999L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1745733600000L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1761454799999L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1761454800000L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1777183199999L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1777183200000L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1792904399999L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1792904400000L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1808632799999L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1808632800000L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1824958799999L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1824958800000L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1840687199999L, -4*60*60*1000, 0);
    ntest("SystemV/AST4ADT", 1840687200000L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1856408399999L, -4*60*60*1000, 1*60*60*1000);
    ntest("SystemV/AST4ADT", 1856408400000L, -4*60*60*1000, 0);
    ntest("SystemV/CST6", 1704088800000L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1704088800000L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1714291199999L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1714291200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1730012399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1730012400000L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1745740799999L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1745740800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1761461999999L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1761462000000L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1777190399999L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1777190400000L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1792911599999L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1792911600000L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1808639999999L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1808640000000L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1824965999999L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1824966000000L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1840694399999L, -6*60*60*1000, 0);
    ntest("SystemV/CST6CDT", 1840694400000L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1856415599999L, -6*60*60*1000, 1*60*60*1000);
    ntest("SystemV/CST6CDT", 1856415600000L, -6*60*60*1000, 0);
    ntest("SystemV/EST5", 1704085200000L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1704085200000L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1714287599999L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1714287600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1730008799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1730008800000L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1745737199999L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1745737200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1761458399999L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1761458400000L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1777186799999L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1777186800000L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1792907999999L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1792908000000L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1808636399999L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1808636400000L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1824962399999L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1824962400000L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1840690799999L, -5*60*60*1000, 0);
    ntest("SystemV/EST5EDT", 1840690800000L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1856411999999L, -5*60*60*1000, 1*60*60*1000);
    ntest("SystemV/EST5EDT", 1856412000000L, -5*60*60*1000, 0);
    ntest("SystemV/HST10", 1704103200000L, -10*60*60*1000, 0);
    ntest("SystemV/MST7", 1704092400000L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1704092400000L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1714294799999L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1714294800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1730015999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1730016000000L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1745744399999L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1745744400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1761465599999L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1761465600000L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1777193999999L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1777194000000L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1792915199999L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1792915200000L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1808643599999L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1808643600000L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1824969599999L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1824969600000L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1840697999999L, -7*60*60*1000, 0);
    ntest("SystemV/MST7MDT", 1840698000000L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1856419199999L, -7*60*60*1000, 1*60*60*1000);
    ntest("SystemV/MST7MDT", 1856419200000L, -7*60*60*1000, 0);
    ntest("SystemV/PST8", 1704096000000L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1704096000000L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1714298399999L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1714298400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1730019599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1730019600000L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1745747999999L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1745748000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1761469199999L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1761469200000L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1777197599999L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1777197600000L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1792918799999L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1792918800000L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1808647199999L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1808647200000L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1824973199999L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1824973200000L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1840701599999L, -8*60*60*1000, 0);
    ntest("SystemV/PST8PDT", 1840701600000L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1856422799999L, -8*60*60*1000, 1*60*60*1000);
    ntest("SystemV/PST8PDT", 1856422800000L, -8*60*60*1000, 0);
    ntest("SystemV/YST9", 1704099600000L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1704099600000L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1714301999999L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1714302000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1730023199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1730023200000L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1745751599999L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1745751600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1761472799999L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1761472800000L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1777201199999L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1777201200000L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1792922399999L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1792922400000L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1808650799999L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1808650800000L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1824976799999L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1824976800000L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1840705199999L, -9*60*60*1000, 0);
    ntest("SystemV/YST9YDT", 1840705200000L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1856426399999L, -9*60*60*1000, 1*60*60*1000);
    ntest("SystemV/YST9YDT", 1856426400000L, -9*60*60*1000, 0);
    ntest("Turkey", 1704056400000L, 3*60*60*1000, 0);
    ntest("UCT", 1704067200000L, 0, 0);
    ntest("US/Alaska", 1704099600000L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1710068399999L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1710068400000L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1730627999999L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1730628000000L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1741517999999L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1741518000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1762077599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1762077600000L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1772967599999L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1772967600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1793527199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1793527200000L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1805021999999L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1805022000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1825581599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1825581600000L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1836471599999L, -9*60*60*1000, 0);
    ntest("US/Alaska", 1836471600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1857031199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("US/Alaska", 1857031200000L, -9*60*60*1000, 0);
    ntest("US/Aleutian", 1704103200000L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1710071999999L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1710072000000L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1730631599999L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1730631600000L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1741521599999L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1741521600000L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1762081199999L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1762081200000L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1772971199999L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1772971200000L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1793530799999L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1793530800000L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1805025599999L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1805025600000L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1825585199999L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1825585200000L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1836475199999L, -10*60*60*1000, 0);
    ntest("US/Aleutian", 1836475200000L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1857034799999L, -10*60*60*1000, 1*60*60*1000);
    ntest("US/Aleutian", 1857034800000L, -10*60*60*1000, 0);
    ntest("US/Arizona", 1704092400000L, -7*60*60*1000, 0);
    ntest("US/Central", 1704088800000L, -6*60*60*1000, 0);
    ntest("US/Central", 1710057599999L, -6*60*60*1000, 0);
    ntest("US/Central", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1730617200000L, -6*60*60*1000, 0);
    ntest("US/Central", 1741507199999L, -6*60*60*1000, 0);
    ntest("US/Central", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1762066800000L, -6*60*60*1000, 0);
    ntest("US/Central", 1772956799999L, -6*60*60*1000, 0);
    ntest("US/Central", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1793516400000L, -6*60*60*1000, 0);
    ntest("US/Central", 1805011199999L, -6*60*60*1000, 0);
    ntest("US/Central", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1825570800000L, -6*60*60*1000, 0);
    ntest("US/Central", 1836460799999L, -6*60*60*1000, 0);
    ntest("US/Central", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Central", 1857020400000L, -6*60*60*1000, 0);
    ntest("US/East-Indiana", 1704085200000L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1710053999999L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1730613600000L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1741503599999L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1762063200000L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1772953199999L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1793512800000L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1805007599999L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1825567200000L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1836457199999L, -5*60*60*1000, 0);
    ntest("US/East-Indiana", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/East-Indiana", 1857016800000L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1704085200000L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1710053999999L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1730613600000L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1741503599999L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1762063200000L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1772953199999L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1793512800000L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1805007599999L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1825567200000L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1836457199999L, -5*60*60*1000, 0);
    ntest("US/Eastern", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Eastern", 1857016800000L, -5*60*60*1000, 0);
    ntest("US/Hawaii", 1704103200000L, -10*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1704088800000L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1710057599999L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1730617200000L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1741507199999L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1762066800000L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1772956799999L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1793516400000L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1805011199999L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1825570800000L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1836460799999L, -6*60*60*1000, 0);
    ntest("US/Indiana-Starke", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("US/Indiana-Starke", 1857020400000L, -6*60*60*1000, 0);
    ntest("US/Michigan", 1704085200000L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1710053999999L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1730613600000L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1741503599999L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1762063200000L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1772953199999L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1793512800000L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1805007599999L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1825567200000L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1836457199999L, -5*60*60*1000, 0);
    ntest("US/Michigan", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("US/Michigan", 1857016800000L, -5*60*60*1000, 0);
    ntest("US/Mountain", 1704092400000L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1710061199999L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1710061200000L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1730620799999L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1730620800000L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1741510799999L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1741510800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1762070399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1762070400000L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1772960399999L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1772960400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1793519999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1793520000000L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1805014799999L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1805014800000L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1825574399999L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1825574400000L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1836464399999L, -7*60*60*1000, 0);
    ntest("US/Mountain", 1836464400000L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1857023999999L, -7*60*60*1000, 1*60*60*1000);
    ntest("US/Mountain", 1857024000000L, -7*60*60*1000, 0);
    ntest("US/Pacific", 1704096000000L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1710064799999L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1730624400000L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1741514399999L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1762074000000L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1772963999999L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1793523600000L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1805018399999L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1825578000000L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1836467999999L, -8*60*60*1000, 0);
    ntest("US/Pacific", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("US/Pacific", 1857027600000L, -8*60*60*1000, 0);
    ntest("US/Samoa", 1704106800000L, -11*60*60*1000, 0);
    ntest("UTC", 1704067200000L, 0, 0);
    ntest("Universal", 1704067200000L, 0, 0);
    ntest("W-SU", 1704056400000L, 3*60*60*1000, 0);
    ntest("WET", 1704067200000L, 0, 0);
    ntest("WET", 1711846799999L, 0, 0);
    ntest("WET", 1711846800000L, 0, 1*60*60*1000);
    ntest("WET", 1729990799999L, 0, 1*60*60*1000);
    ntest("WET", 1729990800000L, 0, 0);
    ntest("WET", 1743296399999L, 0, 0);
    ntest("WET", 1743296400000L, 0, 1*60*60*1000);
    ntest("WET", 1761440399999L, 0, 1*60*60*1000);
    ntest("WET", 1761440400000L, 0, 0);
    ntest("WET", 1774745999999L, 0, 0);
    ntest("WET", 1774746000000L, 0, 1*60*60*1000);
    ntest("WET", 1792889999999L, 0, 1*60*60*1000);
    ntest("WET", 1792890000000L, 0, 0);
    ntest("WET", 1806195599999L, 0, 0);
    ntest("WET", 1806195600000L, 0, 1*60*60*1000);
    ntest("WET", 1824944399999L, 0, 1*60*60*1000);
    ntest("WET", 1824944400000L, 0, 0);
    ntest("WET", 1837645199999L, 0, 0);
    ntest("WET", 1837645200000L, 0, 1*60*60*1000);
    ntest("WET", 1856393999999L, 0, 1*60*60*1000);
    ntest("WET", 1856394000000L, 0, 0);
    ntest("Zulu", 1704067200000L, 0, 0);
    ntest("EST", 1704085200000L, -5*60*60*1000, 0);
    ntest("HST", 1704103200000L, -10*60*60*1000, 0);
    ntest("MST", 1704092400000L, -7*60*60*1000, 0);
    ntest("ACT", 1704033000000L, (9*60+30)*60*1000, 0);
    ntest("AET", 1704027600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1712419199999L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1712419200000L, 10*60*60*1000, 0);
    ntest("AET", 1728143999999L, 10*60*60*1000, 0);
    ntest("AET", 1728144000000L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1743868799999L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1743868800000L, 10*60*60*1000, 0);
    ntest("AET", 1759593599999L, 10*60*60*1000, 0);
    ntest("AET", 1759593600000L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1775318399999L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1775318400000L, 10*60*60*1000, 0);
    ntest("AET", 1791043199999L, 10*60*60*1000, 0);
    ntest("AET", 1791043200000L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1806767999999L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1806768000000L, 10*60*60*1000, 0);
    ntest("AET", 1822492799999L, 10*60*60*1000, 0);
    ntest("AET", 1822492800000L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1838217599999L, 10*60*60*1000, 1*60*60*1000);
    ntest("AET", 1838217600000L, 10*60*60*1000, 0);
    ntest("AET", 1853942399999L, 10*60*60*1000, 0);
    ntest("AET", 1853942400000L, 10*60*60*1000, 1*60*60*1000);
    ntest("AGT", 1704078000000L, -3*60*60*1000, 0);
    ntest("ART", 1704060000000L, 2*60*60*1000, 0);
    ntest("ART", 1714082399999L, 2*60*60*1000, 0);
    ntest("ART", 1714082400000L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1730408399999L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1730408400000L, 2*60*60*1000, 0);
    ntest("ART", 1745531999999L, 2*60*60*1000, 0);
    ntest("ART", 1745532000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1761857999999L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1761858000000L, 2*60*60*1000, 0);
    ntest("ART", 1776981599999L, 2*60*60*1000, 0);
    ntest("ART", 1776981600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1793307599999L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1793307600000L, 2*60*60*1000, 0);
    ntest("ART", 1809035999999L, 2*60*60*1000, 0);
    ntest("ART", 1809036000000L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1824757199999L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1824757200000L, 2*60*60*1000, 0);
    ntest("ART", 1840485599999L, 2*60*60*1000, 0);
    ntest("ART", 1840485600000L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1856206799999L, 2*60*60*1000, 1*60*60*1000);
    ntest("ART", 1856206800000L, 2*60*60*1000, 0);
    ntest("AST", 1704099600000L, -9*60*60*1000, 0);
    ntest("AST", 1710068399999L, -9*60*60*1000, 0);
    ntest("AST", 1710068400000L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1730627999999L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1730628000000L, -9*60*60*1000, 0);
    ntest("AST", 1741517999999L, -9*60*60*1000, 0);
    ntest("AST", 1741518000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1762077599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1762077600000L, -9*60*60*1000, 0);
    ntest("AST", 1772967599999L, -9*60*60*1000, 0);
    ntest("AST", 1772967600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1793527199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1793527200000L, -9*60*60*1000, 0);
    ntest("AST", 1805021999999L, -9*60*60*1000, 0);
    ntest("AST", 1805022000000L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1825581599999L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1825581600000L, -9*60*60*1000, 0);
    ntest("AST", 1836471599999L, -9*60*60*1000, 0);
    ntest("AST", 1836471600000L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1857031199999L, -9*60*60*1000, 1*60*60*1000);
    ntest("AST", 1857031200000L, -9*60*60*1000, 0);
    ntest("BET", 1704078000000L, -3*60*60*1000, 0);
    ntest("BST", 1704045600000L, 6*60*60*1000, 0);
    ntest("CAT", 1704060000000L, 2*60*60*1000, 0);
    ntest("CNT", 1704079800000L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1710048599999L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1710048600000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1730608199999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1730608200000L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1741498199999L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1741498200000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1762057799999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1762057800000L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1772947799999L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1772947800000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1793507399999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1793507400000L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1805002199999L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1805002200000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1825561799999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1825561800000L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1836451799999L, -(3*60+30)*60*1000, 0);
    ntest("CNT", 1836451800000L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1857011399999L, -(3*60+30)*60*1000, 1*60*60*1000);
    ntest("CNT", 1857011400000L, -(3*60+30)*60*1000, 0);
    ntest("CST", 1704088800000L, -6*60*60*1000, 0);
    ntest("CST", 1710057599999L, -6*60*60*1000, 0);
    ntest("CST", 1710057600000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1730617199999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1730617200000L, -6*60*60*1000, 0);
    ntest("CST", 1741507199999L, -6*60*60*1000, 0);
    ntest("CST", 1741507200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1762066799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1762066800000L, -6*60*60*1000, 0);
    ntest("CST", 1772956799999L, -6*60*60*1000, 0);
    ntest("CST", 1772956800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1793516399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1793516400000L, -6*60*60*1000, 0);
    ntest("CST", 1805011199999L, -6*60*60*1000, 0);
    ntest("CST", 1805011200000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1825570799999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1825570800000L, -6*60*60*1000, 0);
    ntest("CST", 1836460799999L, -6*60*60*1000, 0);
    ntest("CST", 1836460800000L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1857020399999L, -6*60*60*1000, 1*60*60*1000);
    ntest("CST", 1857020400000L, -6*60*60*1000, 0);
    ntest("CTT", 1704038400000L, 8*60*60*1000, 0);
    ntest("EAT", 1704056400000L, 3*60*60*1000, 0);
    ntest("ECT", 1704063600000L, 1*60*60*1000, 0);
    ntest("ECT", 1711846799999L, 1*60*60*1000, 0);
    ntest("ECT", 1711846800000L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1729990799999L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1729990800000L, 1*60*60*1000, 0);
    ntest("ECT", 1743296399999L, 1*60*60*1000, 0);
    ntest("ECT", 1743296400000L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1761440399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1761440400000L, 1*60*60*1000, 0);
    ntest("ECT", 1774745999999L, 1*60*60*1000, 0);
    ntest("ECT", 1774746000000L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1792889999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1792890000000L, 1*60*60*1000, 0);
    ntest("ECT", 1806195599999L, 1*60*60*1000, 0);
    ntest("ECT", 1806195600000L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1824944399999L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1824944400000L, 1*60*60*1000, 0);
    ntest("ECT", 1837645199999L, 1*60*60*1000, 0);
    ntest("ECT", 1837645200000L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1856393999999L, 1*60*60*1000, 1*60*60*1000);
    ntest("ECT", 1856394000000L, 1*60*60*1000, 0);
    ntest("IET", 1704085200000L, -5*60*60*1000, 0);
    ntest("IET", 1710053999999L, -5*60*60*1000, 0);
    ntest("IET", 1710054000000L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1730613599999L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1730613600000L, -5*60*60*1000, 0);
    ntest("IET", 1741503599999L, -5*60*60*1000, 0);
    ntest("IET", 1741503600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1762063199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1762063200000L, -5*60*60*1000, 0);
    ntest("IET", 1772953199999L, -5*60*60*1000, 0);
    ntest("IET", 1772953200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1793512799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1793512800000L, -5*60*60*1000, 0);
    ntest("IET", 1805007599999L, -5*60*60*1000, 0);
    ntest("IET", 1805007600000L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1825567199999L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1825567200000L, -5*60*60*1000, 0);
    ntest("IET", 1836457199999L, -5*60*60*1000, 0);
    ntest("IET", 1836457200000L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1857016799999L, -5*60*60*1000, 1*60*60*1000);
    ntest("IET", 1857016800000L, -5*60*60*1000, 0);
    ntest("IST", 1704047400000L, (5*60+30)*60*1000, 0);
    ntest("JST", 1704034800000L, 9*60*60*1000, 0);
    ntest("MIT", 1704020400000L, 13*60*60*1000, 0);
    ntest("NET", 1704052800000L, 4*60*60*1000, 0);
    ntest("NST", 1704020400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1712411999999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1712412000000L, 12*60*60*1000, 0);
    ntest("NST", 1727531999999L, 12*60*60*1000, 0);
    ntest("NST", 1727532000000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1743861599999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1743861600000L, 12*60*60*1000, 0);
    ntest("NST", 1758981599999L, 12*60*60*1000, 0);
    ntest("NST", 1758981600000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1775311199999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1775311200000L, 12*60*60*1000, 0);
    ntest("NST", 1790431199999L, 12*60*60*1000, 0);
    ntest("NST", 1790431200000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1806760799999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1806760800000L, 12*60*60*1000, 0);
    ntest("NST", 1821880799999L, 12*60*60*1000, 0);
    ntest("NST", 1821880800000L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1838210399999L, 12*60*60*1000, 1*60*60*1000);
    ntest("NST", 1838210400000L, 12*60*60*1000, 0);
    ntest("NST", 1853330399999L, 12*60*60*1000, 0);
    ntest("NST", 1853330400000L, 12*60*60*1000, 1*60*60*1000);
    ntest("PLT", 1704049200000L, 5*60*60*1000, 0);
    ntest("PNT", 1704092400000L, -7*60*60*1000, 0);
    ntest("PRT", 1704081600000L, -4*60*60*1000, 0);
    ntest("PST", 1704096000000L, -8*60*60*1000, 0);
    ntest("PST", 1710064799999L, -8*60*60*1000, 0);
    ntest("PST", 1710064800000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1730624399999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1730624400000L, -8*60*60*1000, 0);
    ntest("PST", 1741514399999L, -8*60*60*1000, 0);
    ntest("PST", 1741514400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1762073999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1762074000000L, -8*60*60*1000, 0);
    ntest("PST", 1772963999999L, -8*60*60*1000, 0);
    ntest("PST", 1772964000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1793523599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1793523600000L, -8*60*60*1000, 0);
    ntest("PST", 1805018399999L, -8*60*60*1000, 0);
    ntest("PST", 1805018400000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1825577999999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1825578000000L, -8*60*60*1000, 0);
    ntest("PST", 1836467999999L, -8*60*60*1000, 0);
    ntest("PST", 1836468000000L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1857027599999L, -8*60*60*1000, 1*60*60*1000);
    ntest("PST", 1857027600000L, -8*60*60*1000, 0);
    ntest("SST", 1704027600000L, 11*60*60*1000, 0);
    ntest("VST", 1704042000000L, 7*60*60*1000, 0);
  }

}
/

show errors

alter java source fixTZ compile;

show errors

create or replace package fixTZ as


function getshorty(n varchar2) return varchar2;


procedure pass2;

procedure jexit(x number) as language java name
 'java.lang.System.exit(int)';

function test return number as language java name
 'fixTZ.testall() return int';

end;
/

show errors

create or replace package body fixTZ as

function getshorty(n varchar2) return varchar2 as
sn varchar2(128);
begin
  begin
  select name into sn from obj$ where type#=29 and 
     (name=n or name=(select short from javasnm$ where longdbcs=n));
  exception when no_data_found then sn := null;
  end;
  return sn;
end;



procedure pass2 as
n varchar2(100);
begin 
  if SYS_CONTEXT('USERENV','CON_ID') <= 1 then 
    n := dbms_java_test.funcall('-rehotload', ' '); 
  end if; 
end;

end;
/

show errors

begin
 fixTZ.jexit(0);
exception when others then
 if sqlcode not in (-29515) then raise; end if;
end;
/

call dbms_java.set_output(1000000);

declare
x number := fixTZ.test;
begin
 if x = 0 then
   dbms_output.put_line('##');
   dbms_output.put_line('Bug is in fact present, so this patch is needed');
   dbms_output.put_line('##');
 else
  :user_:='not needed';
 begin
  fixTZ.jexit(0);
 exception when others then
  if sqlcode not in (-29515) then raise; end if;
 end;
 end if;
end;
/

begin
 dbms_output.put_line('');
 dbms_output.put_line('########################################################');
 if  :user_ = 'not needed' then
   dbms_output.put_line('     Bug is not present.  Patch not needed.');
   execute immediate 'drop java source fixTZ';
   execute immediate 'drop package fixTZ';
 else
   dbms_output.put_line('Bug is in fact present, so this patch is needed');
   dbms_output.put_line('Proceed by restarting the database and running script');
   dbms_output.put_line('fixTZb');
 end if;
 dbms_output.put_line('########################################################');
end;
/

spool off
