Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: javavm_src_2/admin/fixTZb.sql
Rem    SQL_SHIPPED_FILE: javavm/admin/fixTZb.sql
Rem    SQL_PHASE: UTILITY
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA



/* This script is part of the fix for Oracle bug 36260537.  The problem
   in this bug is that java timezones in the java VM resident in the
   Oracle database are not up to date with respect to recent changes
   to when Daylight Savings Time applies in various time zones.
   The fix consists of installing a new versions of various data files in
   ORACLE_HOME/javavm/lib/zi, running two scripts, as SYS,
   of which this is the first, shutting down and restarting the instance
   after the first script is run and deferring running any java in the 
   instance until the second script is run.  The scripts will spool their 
   output to files named fixTZa.lst and fixTZb.lst in the 
   directory that is current when the sqlplus session used to run them is 
   started.  The output will contain messages delineated by lines of 
   # characters indicating any errors or the successful installation of 
   the fix.
*/

spool fixTZb
set define off
set serveroutput on
variable user_ varchar2(128)

alter session set java_jit_enabled=false;

begin 
 select username into :user_ from user_users;
 if :user_!='SYS' then
 dbms_output.put_line('########################################################');
 dbms_output.put_line('     This script must be run as SYS, not '||:user_);
 dbms_output.put_line('     Aborting with intentional ORA-00022');
 dbms_output.put_line('########################################################');
end if;end;
/

whenever sqlerror exit

declare foo exception; pragma exception_init(foo, -22);
begin if :user_!='SYS' then raise foo;end if;end;
/

whenever sqlerror continue

declare
x number;
begin

 select count(*) into x from obj$
  where type#=28 and
   (name='FIXTZ' or
    name=(select short from javasnm$ where longdbcs='FIXTZ'));
 if x = 0 then
  dbms_output.put_line('############################################################');
  dbms_output.put_line('  The packages that would be defined by the first script.');
  dbms_output.put_line('  in this patch are not present.  This is either because');
  dbms_output.put_line('  the first script determined the bug was not present,');
  dbms_output.put_line('  in which case you should not be trying to run the second');
  dbms_output.put_line('  script, or because the first script was never run, in');
  dbms_output.put_line('  which case you should run it now, or because the second ');
  dbms_output.put_line('  script has already been run, in which case you should');
  dbms_output.put_line('  not be trying to rerun it without first starting over');
  dbms_output.put_line('  by running the first script.');
  dbms_output.put_line('  ');
  dbms_output.put_line('  ');
  dbms_output.put_line('  Aborting with intentional ORA-00022');
  dbms_output.put_line('############################################################');
 :user_:='aborting';
end if;
end;
/

whenever sqlerror exit

declare foo exception; pragma exception_init(foo, -22);
begin if :user_!='SYS' then raise foo;end if;end;
/

whenever sqlerror continue

declare
 n1 varchar2(128) := fixTZ.getshorty('sun/util/calendar/ZoneInfoFile');
 n2 varchar2(128) :=
  fixTZ.getshorty('oracle/aurora/rdbms/security/PolicyTable');
 x number;
begin
  select count(*) into x from x$kglob
     where kglobtyp=29 and kglnaobj in (n1,n2);
  if x > 0 then
 dbms_output.put_line('########################################################');
 dbms_output.put_line('     The instance must be restarted before this');
 dbms_output.put_line('     script can be run');
 dbms_output.put_line('     Aborting with intentional ORA-00022');
 dbms_output.put_line('########################################################');
 :user_:='must restart instance';
end if;
end;
/

whenever sqlerror exit

declare foo exception; pragma exception_init(foo, -22);
begin if :user_!='SYS' then raise foo;end if;end;
/

whenever sqlerror continue

call dbms_java.set_output(1000000);
alter session set "_ORACLE_SCRIPT"=true;
declare
x number;
begin
  fixTZ.pass2;
  x := fixTZ.test;
  dbms_output.put_line('########################################################');
  if x = 0 then
  dbms_output.put_line('  Bug is still present.  Patch failed!!');
  else
  dbms_output.put_line('  Bug is no longer present.  Patch succeeded.');
  end if;
  dbms_output.put_line('########################################################');
end;
/

begin
 initjvmaux.drp('drop java source fixTZ');
 initjvmaux.drp('drop package fixTZ');
end;
/

spool off
