/*
 * Decompiled with CFR 0.152.
 */
package de.transfact.smartcard;

import de.transfact.smartcard.RFIDReaderListener;
import de.transfact.smartcard.SoundPlayer;
import java.awt.Desktop;
import java.net.URI;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;

public class RFIDReader
implements Runnable {
    private RFIDReaderListener listener;
    private static final long terminalSearchInterval = 10000L;
    private static final long pollMillis = 500L;
    private static boolean silent = false;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public void run() {
        CardTerminal terminal = null;
        boolean isScannedSuccess = false;
        while (true) {
            if (terminal == null) {
                try {
                    TerminalFactory factory = TerminalFactory.getInstance("PC/SC", null);
                    if (factory != null) {
                        List<CardTerminal> terminals = factory.terminals().list();
                        terminal = terminals.size() > 0 ? terminals.get(0) : null;
                    }
                }
                catch (Exception factory) {
                    // empty catch block
                }
                if (terminal == null) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (terminal == null) continue;
            try {
                block20: {
                    if (!terminal.waitForCardPresent(0L)) continue;
                    try {
                        try {
                            if (!isScannedSuccess) {
                                Card card = terminal.connect("*");
                                CardChannel channel = card.getBasicChannel();
                                byte[] byArray = new byte[5];
                                byArray[0] = -1;
                                byArray[1] = -54;
                                CommandAPDU READ = new CommandAPDU(byArray);
                                ResponseAPDU response = channel.transmit(READ);
                                String uid = new String(RFIDReader.encodeHex(response.getData())).toUpperCase();
                                card.disconnect(true);
                                if (uid != null && uid.length() > 0) {
                                    isScannedSuccess = true;
                                    if (!silent) {
                                        RFIDReader.playBeep();
                                    }
                                    if (this.listener != null) {
                                        this.listener.scan(uid);
                                    }
                                }
                            }
                            if (terminal.waitForCardAbsent(0L)) {
                                isScannedSuccess = false;
                            }
                        }
                        catch (Exception card) {
                            isScannedSuccess = false;
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        isScannedSuccess = false;
                        throw throwable;
                    }
                    isScannedSuccess = false;
                }
                Thread.sleep(500L);
                continue;
            }
            catch (Exception e) {
                terminal = null;
                continue;
            }
            break;
        }
    }

    public void setListener(RFIDReaderListener listener) {
        this.listener = listener;
    }

    private static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
            ++i;
        }
        return out;
    }

    public static synchronized void playBeep() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SoundPlayer player = new SoundPlayer();
                    player.play();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }).start();
    }

    public static synchronized void openFirefoxUrl(final String url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }).start();
    }
}

