/*
 * Decompiled with CFR 0.152.
 */
package de.transfact.stempeluhr;

import de.transfact.smartcard.RFIDReader;
import de.transfact.smartcard.RFIDReaderListener;
import de.transfact.stempeluhr.ModelFormatter;
import de.transfact.stempeluhr.Scheduler;
import de.transfact.stempeluhrmodel.OpenLot;
import de.transfact.stempeluhrmodel.UserData;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.Duration;
import javafx.util.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

public class StempeluhrController
implements Initializable,
RFIDReaderListener {
    @FXML
    private BorderPane logopane;
    @FXML
    private BorderPane contentpane;
    @FXML
    private TableView<OpenLot> tablepane;
    @FXML
    private Button stampin;
    @FXML
    private Button stampout;
    @FXML
    private Button stampundo;
    private final ObjectProperty<UserData> model = new SimpleObjectProperty((Object)new UserData());
    private final Timeline panelswitcher = new Timeline();
    private final Timeline statusmessage = new Timeline();

    public final ObjectProperty<UserData> modelProperty() {
        return this.model;
    }

    public final UserData getModel() {
        return (UserData)this.model.get();
    }

    public void setModel(UserData model) {
        this.model.set((Object)model);
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.logopane.setVisible(true);
        this.tablepane.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty(this.getModel().getOpenlots()));
        this.tablepane.managedProperty().bind((ObservableValue)Bindings.isNotEmpty(this.getModel().getOpenlots()));
        Scheduler config = Scheduler.schedule(Duration.seconds((double)10.0), () -> {
            Throwable throwable;
            Properties p = new Properties();
            try {
                File file = new File("config.properties");
                if (!file.exists()) {
                    throw new Exception("No configuration file found.");
                }
                throwable = null;
                Object var4_6 = null;
                try (FileReader reader = new FileReader(file);){
                    p.load(new FileReader("config.properties"));
                    String uri = p.getProperty("stempeluhr.uri");
                    if (uri == null || uri.length() == 0) {
                        throw new Exception("Property \"stempeluhr.uri\" in configuration file not found. ");
                    }
                    new URI(uri);
                    this.getModel().setUri(uri);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.getModel().setUri(null);
                this.refreshError(new JSONObject("{ message: " + JSONObject.quote((String)(e2.getLocalizedMessage() != null ? e2.getLocalizedMessage() : e2.getClass().getName())) + "}"));
            }
            throwable = this.logopane.getBottom();
            if (throwable instanceof HBox) {
                HBox bottomBOX = (HBox)throwable;
                bottomBOX.getChildren().clear();
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || entry.getKey().toString().length() <= 18 || !entry.getKey().toString().startsWith("stempeluhr.button.")) continue;
                    String text = entry.getKey().toString().substring(18);
                    String code = entry.getValue().toString();
                    Button button = new Button();
                    button.setAlignment(Pos.CENTER);
                    button.setOnMouseClicked(e -> this.scan(code));
                    button.setText(text);
                    bottomBOX.getChildren().add((Object)button);
                }
            }
        });
        config.start();
        DateTimeFormatter clockFormatter = DateTimeFormatter.ofPattern("EEEE dd. MMMM\nHH:mm 'Uhr'");
        Scheduler clock = Scheduler.schedule(Duration.millis((double)50.0), () -> this.getModel().setTimestamp(LocalDateTime.now().format(clockFormatter)));
        clock.start();
        RFIDReader reader = new RFIDReader();
        reader.setListener(this);
        Thread.startVirtualThread(reader);
    }

    private Pair<Integer, JSONObject> callapi(String uri, String ... headers) {
        HttpResponse<String> response = null;
        JSONObject json = null;
        try {
            HttpRequest request = HttpRequest.newBuilder().timeout(java.time.Duration.ofSeconds(2L)).uri(URI.create(uri)).headers(headers).GET().build();
            response = HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofString());
            if (response != null) {
                try {
                    json = new JSONObject(response.body());
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            json = new JSONObject("{ message: " + JSONObject.quote((String)"Das Transfact System ist aktuell nicht erreichbar") + "}");
        }
        catch (Exception e) {
            e.printStackTrace();
            json = new JSONObject("{ message: " + JSONObject.quote((String)(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getName())) + "}");
        }
        return new Pair((Object)(response != null ? response.statusCode() : 500), (Object)json);
    }

    @Override
    public void scan(String uid) {
        if (this.getModel().getUri() == null) {
            return;
        }
        Pair<Integer, JSONObject> result = this.callapi(this.getModel().getUri(), "UserId", uid);
        if ((Integer)result.getKey() == 200 && result.getValue() != null) {
            this.refresh((JSONObject)result.getValue());
            this.getModel().setAccesskey(uid);
            this.switch2Contentpane();
        } else {
            this.refreshError((JSONObject)result.getValue());
        }
    }

    public void stampin() {
        this.stamp("in");
    }

    public void stampout() {
        this.stamp("out");
    }

    public void stampundo() {
        this.stamp("undo");
    }

    private void stamp(String execute) {
        if (this.getModel().getUri() == null) {
            return;
        }
        Pair<Integer, JSONObject> result = this.callapi(this.getModel().getUri() + "?execute=" + execute, "UserId", this.getModel().getAccesskey());
        this.getModel().setAccesskey(null);
        if ((Integer)result.getKey() == 200 && result.getValue() != null) {
            this.refresh((JSONObject)result.getValue());
        } else {
            this.refreshError((JSONObject)result.getValue());
        }
        this.switch2Logopane();
    }

    private void switch2Contentpane() {
        this.logopane.setVisible(false);
        this.contentpane.setVisible(true);
        this.panelswitcher.stop();
        this.panelswitcher.getKeyFrames().clear();
        this.panelswitcher.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.contentpane.opacityProperty(), (Object)0)}));
        this.panelswitcher.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)this.contentpane.opacityProperty(), (Object)1)}));
        this.panelswitcher.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)5150.0), new KeyValue[]{new KeyValue((WritableValue)this.contentpane.visibleProperty(), (Object)false)}));
        this.panelswitcher.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)5150.0), new KeyValue[]{new KeyValue((WritableValue)this.logopane.visibleProperty(), (Object)true)}));
        this.panelswitcher.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)5150.0), new KeyValue[]{new KeyValue((WritableValue)this.logopane.opacityProperty(), (Object)0)}));
        this.panelswitcher.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)5300.0), new KeyValue[]{new KeyValue((WritableValue)this.logopane.opacityProperty(), (Object)1)}));
        this.panelswitcher.play();
    }

    private void switch2Logopane() {
        this.contentpane.setVisible(false);
        this.logopane.setVisible(true);
        this.panelswitcher.stop();
        this.panelswitcher.getKeyFrames().clear();
        this.panelswitcher.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.logopane.opacityProperty(), (Object)0)}));
        this.panelswitcher.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)this.logopane.opacityProperty(), (Object)1)}));
        this.panelswitcher.play();
    }

    public static void autoResizeColumns(TableView<?> table) {
        Font fontHeader = Font.font((String)"Liberation Sans", (FontWeight)FontWeight.BOLD, (double)18.0);
        Font fontBody = Font.font((String)"Liberation Sans", (FontWeight)FontWeight.NORMAL, (double)18.0);
        table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        table.getColumns().stream().forEach(column -> {
            Text t = new Text(column.getText());
            t.setFont(fontHeader);
            double max = Math.max(t.getLayoutBounds().getWidth() + 20.0, column.getMinWidth());
            int i = 0;
            while (i < table.getItems().size()) {
                if (column.getCellData(i) != null) {
                    t = new Text(column.getCellData(i).toString());
                    t.setFont(fontBody);
                    double calcwidth = t.getLayoutBounds().getWidth();
                    calcwidth += 20.0;
                    if (calcwidth > max) {
                        max = calcwidth;
                    }
                }
                ++i;
            }
            column.setMinWidth(max);
            column.setPrefWidth(max);
        });
    }

    private void refresh(JSONObject json) {
        Platform.runLater(() -> {
            try {
                ArrayList openlots = new ArrayList();
                if (json.opt("y0Openlots") != null && !json.isNull("y0Openlots")) {
                    JSONArray array = json.getJSONArray("y0Openlots");
                    array.forEach(o -> {
                        if (o instanceof JSONObject) {
                            JSONObject object = (JSONObject)o;
                            OpenLot lot = new OpenLot();
                            lot.setLotnumber(object.optString("lotnumber"));
                            Object description = object.optString("description");
                            if (((String)description).length() > 64) {
                                description = ((String)description).substring(0, 61) + "...";
                            }
                            lot.setDescription((String)description);
                            Object instruction = object.optString("instruction");
                            if (((String)instruction).length() > 64) {
                                instruction = ((String)instruction).substring(0, 61) + "...";
                            }
                            lot.setInstruction((String)instruction);
                            Object ressource = object.optString("ressource");
                            if (((String)ressource).length() > 25) {
                                ressource = ((String)ressource).substring(0, 22) + "...";
                            }
                            lot.setRessource((String)ressource);
                            String timestamp = object.opt("timestamp") != null && !object.isNull("timestamp") ? new SimpleDateFormat("dd.MM.yyyy HH:mm").format(new Date(object.getLong("timestamp"))) : "";
                            lot.setTimestamp(timestamp);
                            openlots.add(lot);
                        }
                    });
                }
                this.getModel().getOpenlots().setAll(openlots);
                StempeluhrController.autoResizeColumns(this.tablepane);
                this.getModel().setMitarbeiter(json.opt("mitarbeiter") != null ? json.optString("mitarbeiter", "-----") : "-----");
                this.getModel().setEingestempelt(json.opt("eingestempelt") != null && !json.isNull("eingestempelt") ? new SimpleDateFormat("HH:mm").format(new Date(json.getLong("eingestempelt"))) : "--:--");
                this.getModel().setAusgestempelt(json.optDouble("offen") == 0.0 && json.opt("ausgestempelt") != null && !json.isNull("ausgestempelt") ? new SimpleDateFormat("HH:mm").format(new Date(json.getLong("ausgestempelt"))) : "--:--");
                this.getModel().setPauseGestempelt(ModelFormatter.timeToString(json.getBigDecimal("pauseGestempelt")));
                this.getModel().setPauseEffektiv(ModelFormatter.timeToString(json.getBigDecimal("pauseEffektiv")));
                this.getModel().setAnwesenheit(ModelFormatter.timeToString(json.getBigDecimal("anwesenheit")));
                this.getModel().setArbeitszeitEffektiv(ModelFormatter.timeToString(json.getBigDecimal("arbeitszeitEffektiv")));
                this.stampin.setDisable(json.optDouble("offen") == 1.0);
                this.stampout.setDisable(json.optDouble("offen") == 0.0);
                this.stampundo.setDisable(json.optDouble("korrigierbar") == 0.0);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getModel().setAccesskey(null);
                this.refreshError(new JSONObject("{ message: " + JSONObject.quote((String)(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getName())) + "}"));
                this.switch2Logopane();
            }
        });
        String message = (json != null ? json.optString("mitarbeiter", "Mitarbeiter") : "Mitarbeiter") + " erfolgreich";
        this.statusmessage.stop();
        this.statusmessage.getKeyFrames().clear();
        this.statusmessage.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)0.0), event -> this.getModel().setMessage(message + (json.optDouble("offen") == 1.0 ? " eingestempelt" : " ausgestempelt")), new KeyValue[0]));
        this.statusmessage.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)4000.0), event -> this.getModel().setMessage(null), new KeyValue[0]));
        this.statusmessage.play();
    }

    private void refreshError(JSONObject json) {
        String error = json != null ? json.optString("message", "Anfrage nicht m\u00f6glich") : "Anfrage nicht m\u00f6glich";
        this.statusmessage.stop();
        this.statusmessage.getKeyFrames().clear();
        this.statusmessage.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)0.0), event -> this.getModel().setMessage(error), new KeyValue[0]));
        this.statusmessage.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)100.0), event -> this.getModel().setMessage(null), new KeyValue[0]));
        this.statusmessage.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)200.0), event -> this.getModel().setMessage(error), new KeyValue[0]));
        this.statusmessage.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), event -> this.getModel().setMessage(null), new KeyValue[0]));
        this.statusmessage.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)400.0), event -> this.getModel().setMessage(error), new KeyValue[0]));
        this.statusmessage.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)4000.0), event -> this.getModel().setMessage(null), new KeyValue[0]));
        this.statusmessage.play();
    }
}

